/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.io.netty.handler.ssl.ocsp;

import javax.net.ssl.SSLHandshakeException;
import org.talend.__shade__.io.netty.channel.ChannelHandlerContext;
import org.talend.__shade__.io.netty.channel.ChannelInboundHandlerAdapter;
import org.talend.__shade__.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import org.talend.__shade__.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.talend.__shade__.io.netty.util.internal.ObjectUtil;

public abstract class OcspClientHandler
extends ChannelInboundHandlerAdapter {
    private final ReferenceCountedOpenSslEngine engine;

    protected OcspClientHandler(ReferenceCountedOpenSslEngine engine) {
        this.engine = ObjectUtil.checkNotNull(engine, "engine");
    }

    protected abstract boolean verify(ChannelHandlerContext var1, ReferenceCountedOpenSslEngine var2) throws Exception;

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof SslHandshakeCompletionEvent) {
            ctx.pipeline().remove(this);
            SslHandshakeCompletionEvent event = (SslHandshakeCompletionEvent)evt;
            if (event.isSuccess() && !this.verify(ctx, this.engine)) {
                throw new SSLHandshakeException("Bad OCSP response");
            }
        }
        ctx.fireUserEventTriggered(evt);
    }
}

