/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.Serializable;

public abstract class ThreadLocalBufferCache<T>
implements Serializable {
    private final ThreadLocal<T> buffers;
    private final int defaultSize;

    public ThreadLocalBufferCache(final int defaultSize) {
        this.buffers = new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                return ThreadLocalBufferCache.this.newValue(defaultSize);
            }
        };
        this.defaultSize = defaultSize;
    }

    protected abstract T newValue(int var1);

    public T getCache() {
        T cachedLoadedChars = this.buffers.get();
        if (cachedLoadedChars == null) {
            return this.newValue(this.defaultSize);
        }
        this.buffers.set(null);
        return cachedLoadedChars;
    }

    public void release(T buffer) {
        this.buffers.set(buffer);
    }
}

