/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.jsonb.extension;

import java.io.StringReader;
import java.io.Writer;
import java.util.function.Consumer;
import org.talend.__shade__.javax.json.Json;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonReader;
import org.talend.__shade__.javax.json.JsonValue;

public class JsonValueWriter
extends Writer
implements Consumer<JsonValue> {
    private JsonValue result;
    private StringBuilder fallbackOutput;

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.fallbackOutput == null) {
            this.fallbackOutput = new StringBuilder();
        }
        this.fallbackOutput.append(cbuf, off, len);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.flush();
    }

    @Deprecated
    public void setResult(JsonValue result) {
        this.result = result;
    }

    public JsonValue getResult() {
        if (this.result == null && this.fallbackOutput != null) {
            try (JsonReader reader = Json.createReader(new StringReader(this.fallbackOutput.toString()));){
                this.result = reader.readValue();
            }
        }
        return this.result;
    }

    public JsonObject getObject() {
        return this.getResult().asJsonObject();
    }

    public JsonArray getArray() {
        return this.getResult().asJsonArray();
    }

    @Override
    public void accept(JsonValue jsonValue) {
        this.result = jsonValue;
    }
}

