/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.javax.json;

import org.talend.__shade__.javax.json.EmptyJsonArray;
import org.talend.__shade__.javax.json.EmptyJsonObject;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonObject;

public interface JsonValue {
    public static final JsonObject EMPTY_JSON_OBJECT = new EmptyJsonObject();
    public static final JsonArray EMPTY_JSON_ARRAY = new EmptyJsonArray();
    public static final JsonValue NULL = new JsonValue(){

        @Override
        public ValueType getValueType() {
            return ValueType.NULL;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsonValue && this.getValueType().equals((Object)((JsonValue)JsonValue.class.cast(obj)).getValueType());
        }

        public int hashCode() {
            return ValueType.NULL.hashCode();
        }

        @Override
        public String toString() {
            return "null";
        }
    };
    public static final JsonValue TRUE = new JsonValue(){

        @Override
        public ValueType getValueType() {
            return ValueType.TRUE;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsonValue && this.getValueType().equals((Object)((JsonValue)JsonValue.class.cast(obj)).getValueType());
        }

        public int hashCode() {
            return ValueType.TRUE.hashCode();
        }

        @Override
        public String toString() {
            return Boolean.TRUE.toString();
        }
    };
    public static final JsonValue FALSE = new JsonValue(){

        @Override
        public ValueType getValueType() {
            return ValueType.FALSE;
        }

        public boolean equals(Object obj) {
            return obj instanceof JsonValue && this.getValueType().equals((Object)((JsonValue)JsonValue.class.cast(obj)).getValueType());
        }

        public int hashCode() {
            return ValueType.FALSE.hashCode();
        }

        @Override
        public String toString() {
            return Boolean.FALSE.toString();
        }
    };

    public ValueType getValueType();

    public String toString();

    default public JsonObject asJsonObject() {
        return (JsonObject)JsonObject.class.cast(this);
    }

    default public JsonArray asJsonArray() {
        return (JsonArray)JsonArray.class.cast(this);
    }

    public static enum ValueType {
        ARRAY,
        OBJECT,
        STRING,
        NUMBER,
        TRUE,
        FALSE,
        NULL;

    }
}

