/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import org.talend.__shade__.io.netty.channel.ChannelHandler;
import org.talend.__shade__.io.netty.channel.ChannelInitializer;
import org.talend.__shade__.io.netty.channel.ChannelPipeline;
import org.talend.__shade__.io.netty.channel.SimpleChannelInboundHandler;
import org.talend.__shade__.io.netty.channel.socket.SocketChannel;
import org.talend.__shade__.io.netty.handler.codec.http.HttpContentCompressor;
import org.talend.__shade__.io.netty.handler.codec.http.HttpContentDecompressor;
import org.talend.__shade__.io.netty.handler.codec.http.HttpObjectAggregator;
import org.talend.__shade__.io.netty.handler.codec.http.HttpRequestDecoder;
import org.talend.__shade__.io.netty.handler.codec.http.HttpResponseEncoder;
import org.talend.__shade__.io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import org.talend.__shade__.io.netty.handler.logging.LogLevel;
import org.talend.__shade__.io.netty.handler.logging.LoggingHandler;
import org.talend.__shade__.io.netty.handler.stream.ChunkedWriteHandler;
import org.talend.sdk.component.junit.http.api.HttpApiHandler;
import org.talend.sdk.component.junit.http.internal.impl.DefaultResponseLocatorCapturingHandler;
import org.talend.sdk.component.junit.http.internal.impl.Handlers;
import org.talend.sdk.component.junit.http.internal.impl.PassthroughHandler;
import org.talend.sdk.component.junit.http.internal.impl.ServingProxyHandler;

public class ProxyInitializer
extends ChannelInitializer<SocketChannel> {
    private final HttpApiHandler api;

    @Override
    protected void initChannel(SocketChannel channel) {
        SimpleChannelInboundHandler handler;
        boolean degzip;
        ChannelPipeline pipeline = channel.pipeline();
        if (Handlers.isActive("capture")) {
            degzip = true;
            handler = new DefaultResponseLocatorCapturingHandler(this.api);
        } else if (Handlers.isActive("passthrough")) {
            degzip = false;
            handler = new PassthroughHandler(this.api);
        } else {
            degzip = true;
            handler = new ServingProxyHandler(this.api);
        }
        pipeline.addLast("logging", (ChannelHandler)new LoggingHandler(LogLevel.valueOf(this.api.getLogLevel()))).addLast("http-decoder", (ChannelHandler)new HttpRequestDecoder());
        if (degzip) {
            pipeline.addLast("gzip-decompressor", (ChannelHandler)new HttpContentDecompressor());
        }
        pipeline.addLast("http-encoder", (ChannelHandler)new HttpResponseEncoder()).addLast("gzip-compressor", (ChannelHandler)new HttpContentCompressor()).addLast("http-keepalive", (ChannelHandler)new HttpServerKeepAliveHandler()).addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE)).addLast("chunked-writer", (ChannelHandler)new ChunkedWriteHandler()).addLast("talend-junit-api-server", (ChannelHandler)handler);
    }

    public ProxyInitializer(HttpApiHandler api) {
        this.api = api;
    }
}

