/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Meta {
    private Meta() {
    }

    public static <T extends Annotation> T getAnnotation(AccessibleObject holder, Class<T> api) {
        T annotation = holder.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        return Meta.findMeta(holder.getAnnotations(), api);
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> api) {
        T annotation = clazz.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        return Meta.findMeta(clazz.getAnnotations(), api);
    }

    public static <T extends Annotation> T getAnnotation(Package pck, Class<T> api) {
        T annotation = pck.getAnnotation(api);
        if (annotation != null) {
            return annotation;
        }
        return Meta.findMeta(pck.getAnnotations(), api);
    }

    public static <T extends Annotation> T findMeta(Annotation[] annotations, Class<T> api) {
        for (Annotation a : annotations) {
            Class<? extends Annotation> userType = a.annotationType();
            T aa = userType.getAnnotation(api);
            if (aa == null) continue;
            boolean overriden = false;
            HashMap<String, Method> mapping = new HashMap<String, Method>();
            for (Class cm : Arrays.asList(api, userType)) {
                for (Method m : cm.getMethods()) {
                    overriden = mapping.put(m.getName(), m) != null || overriden;
                }
            }
            if (!overriden) {
                return aa;
            }
            return (T)((Annotation)api.cast(Meta.newAnnotation(mapping, a, aa)));
        }
        return null;
    }

    private static <T extends Annotation> T newAnnotation(final Map<String, Method> methodMapping, final Annotation user, final T johnzon) {
        return (T)((Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{johnzon.annotationType()}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method m = (Method)methodMapping.get(method.getName());
                try {
                    if (m.getDeclaringClass() == user.annotationType()) {
                        return m.invoke((Object)user, args);
                    }
                    return m.invoke((Object)johnzon, args);
                }
                catch (InvocationTargetException ite) {
                    throw ite.getTargetException();
                }
            }
        }));
    }
}

