/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonArrayBuilder;
import org.talend.__shade__.javax.json.JsonException;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonObjectBuilder;
import org.talend.__shade__.javax.json.JsonPointer;
import org.talend.__shade__.javax.json.JsonStructure;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.spi.JsonProvider;
import org.talend.__shade__.org.apache.johnzon.core.JsonPointerUtil;

public class JsonPointerImpl
implements JsonPointer {
    private final JsonProvider provider;
    private final String jsonPointer;
    private final List<String> referenceTokens = new ArrayList<String>();
    private final String lastReferenceToken;
    private static final Pattern IS_NUMBER = Pattern.compile("\\d+");

    public JsonPointerImpl(JsonProvider provider, String jsonPointer) {
        String[] encodedReferenceTokens;
        if (jsonPointer == null) {
            throw new NullPointerException("jsonPointer must not be null");
        }
        if (!jsonPointer.equals("") && !jsonPointer.startsWith("/")) {
            throw new JsonException("A non-empty JsonPointer string must begin with a '/'");
        }
        this.provider = provider;
        this.jsonPointer = jsonPointer;
        for (String encodedReferenceToken : encodedReferenceTokens = jsonPointer.split("/", -1)) {
            this.referenceTokens.add(JsonPointerUtil.decode(encodedReferenceToken));
        }
        this.lastReferenceToken = this.referenceTokens.get(this.referenceTokens.size() - 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPointerImpl that = (JsonPointerImpl)obj;
        return this.jsonPointer.equals(that.jsonPointer);
    }

    public int hashCode() {
        return this.jsonPointer.hashCode();
    }

    @Override
    public JsonValue getValue(JsonStructure target) {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        if (this.isEmptyJsonPointer()) {
            return target;
        }
        JsonValue jsonValue = target;
        for (int i = 1; i < this.referenceTokens.size(); ++i) {
            jsonValue = this.getValue(jsonValue, this.referenceTokens.get(i), i, this.referenceTokens.size() - 1);
        }
        return jsonValue;
    }

    @Override
    public boolean containsValue(JsonStructure target) {
        try {
            this.getValue(target);
            return true;
        }
        catch (JsonException je) {
            return false;
        }
    }

    public JsonStructure add(JsonStructure target, JsonValue value) {
        this.validateAdd(target);
        if (this.isEmptyJsonPointer()) {
            if (value.getClass() != target.getClass()) {
                throw new JsonException("The value must have the same type as the target");
            }
            return (JsonStructure)value;
        }
        return this.addInternal(target, value);
    }

    public JsonObject add(JsonObject target, JsonValue value) {
        this.validateAdd(target);
        return this.addInternal(target, value);
    }

    public JsonArray add(JsonArray target, JsonValue value) {
        this.validateAdd(target);
        return this.addInternal(target, value);
    }

    public JsonStructure replace(JsonStructure target, JsonValue value) {
        if (target instanceof JsonObject) {
            return this.replace((JsonObject)target, value);
        }
        return this.replace((JsonArray)target, value);
    }

    public JsonObject replace(JsonObject target, JsonValue value) {
        return this.add(this.remove(target), value);
    }

    public JsonArray replace(JsonArray target, JsonValue value) {
        return this.add(this.remove(target), value);
    }

    public JsonStructure remove(JsonStructure target) {
        if (target instanceof JsonObject) {
            return this.remove((JsonObject)target);
        }
        return this.remove((JsonArray)target);
    }

    public JsonObject remove(JsonObject target) {
        this.validateRemove(target);
        return (JsonObject)this.remove(target, 1, this.referenceTokens.size() - 1);
    }

    public JsonArray remove(JsonArray target) {
        this.validateRemove(target);
        return (JsonArray)this.remove(target, 1, this.referenceTokens.size() - 1);
    }

    String getJsonPointer() {
        return this.jsonPointer;
    }

    private void validateAdd(JsonValue target) {
        this.validateJsonPointer(target, this.referenceTokens.size() - 1);
    }

    private void validateRemove(JsonValue target) {
        this.validateJsonPointer(target, this.referenceTokens.size());
        if (this.isEmptyJsonPointer()) {
            throw new JsonException("The reference must not be the target");
        }
    }

    private boolean isEmptyJsonPointer() {
        return this.jsonPointer.equals("");
    }

    private JsonValue getValue(JsonValue jsonValue, String referenceToken, int currentPosition, int referencePosition) {
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            if ((jsonValue = (JsonValue)jsonObject.get(referenceToken)) != null) {
                return jsonValue;
            }
            throw new JsonException("'" + jsonObject + "' contains no value for name '" + referenceToken + "'");
        }
        if (jsonValue instanceof JsonArray) {
            this.validateArrayIndex(referenceToken);
            try {
                JsonArray jsonArray = (JsonArray)jsonValue;
                int arrayIndex = Integer.parseInt(referenceToken);
                this.validateArraySize(jsonArray, arrayIndex, jsonArray.size());
                return (JsonValue)jsonArray.get(arrayIndex);
            }
            catch (NumberFormatException e) {
                throw new JsonException("'" + referenceToken + "' is no valid array index", e);
            }
        }
        if (currentPosition != referencePosition) {
            return jsonValue;
        }
        throw new JsonException("'" + jsonValue + "' contains no element for '" + referenceToken + "'");
    }

    private <T extends JsonStructure> T addInternal(T jsonValue, JsonValue newValue) {
        ArrayList<String> currentPath = new ArrayList<String>();
        currentPath.add("");
        return (T)((JsonStructure)this.addInternal(jsonValue, newValue, currentPath));
    }

    private JsonValue addInternal(JsonValue jsonValue, JsonValue newValue, List<String> currentPath) {
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            JsonObjectBuilder objectBuilder = this.provider.createObjectBuilder();
            if (jsonObject.isEmpty() && this.isPositionToAdd(currentPath)) {
                objectBuilder.add(this.lastReferenceToken, newValue);
            } else {
                for (Map.Entry entry : jsonObject.entrySet()) {
                    currentPath.add((String)entry.getKey());
                    objectBuilder.add((String)entry.getKey(), this.addInternal((JsonValue)entry.getValue(), newValue, currentPath));
                    currentPath.remove(entry.getKey());
                    if (!this.isPositionToAdd(currentPath)) continue;
                    objectBuilder.add(this.lastReferenceToken, newValue);
                }
            }
            return objectBuilder.build();
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            JsonArrayBuilder arrayBuilder = this.provider.createArrayBuilder();
            int arrayIndex = -1;
            if (this.isPositionToAdd(currentPath)) {
                arrayIndex = this.getArrayIndex(this.lastReferenceToken, jsonArray, true);
            }
            int jsonArraySize = jsonArray.size();
            for (int i = 0; i <= jsonArraySize; ++i) {
                if (i == arrayIndex) {
                    arrayBuilder.add(newValue);
                }
                if (i == jsonArraySize) break;
                String path = String.valueOf(i);
                currentPath.add(path);
                arrayBuilder.add(this.addInternal((JsonValue)jsonArray.get(i), newValue, currentPath));
                currentPath.remove(path);
            }
            return arrayBuilder.build();
        }
        return jsonValue;
    }

    private boolean isPositionToAdd(List<String> currentPath) {
        return currentPath.size() == this.referenceTokens.size() - 1 && currentPath.get(currentPath.size() - 1).equals(this.referenceTokens.get(this.referenceTokens.size() - 2));
    }

    private JsonValue remove(JsonValue jsonValue, int currentPosition, int referencePosition) {
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            JsonObjectBuilder objectBuilder = this.provider.createObjectBuilder();
            for (Map.Entry entry : jsonObject.entrySet()) {
                if (currentPosition == referencePosition && this.lastReferenceToken.equals(entry.getKey())) continue;
                objectBuilder.add((String)entry.getKey(), this.remove((JsonValue)entry.getValue(), currentPosition + 1, referencePosition));
            }
            return objectBuilder.build();
        }
        if (jsonValue instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            JsonArrayBuilder arrayBuilder = this.provider.createArrayBuilder();
            int arrayIndex = -1;
            if (currentPosition == referencePosition && IS_NUMBER.matcher(this.lastReferenceToken).matches()) {
                arrayIndex = this.getArrayIndex(this.lastReferenceToken, jsonArray, false);
            }
            int jsonArraySize = jsonArray.size();
            for (int i = 0; i < jsonArraySize; ++i) {
                if (i == arrayIndex) continue;
                arrayBuilder.add(this.remove((JsonValue)jsonArray.get(i), currentPosition + 1, referencePosition));
            }
            return arrayBuilder.build();
        }
        return jsonValue;
    }

    private int getArrayIndex(String referenceToken, JsonArray jsonArray, boolean addOperation) {
        if (addOperation && referenceToken.equals("-")) {
            return jsonArray.size();
        }
        this.validateArrayIndex(referenceToken);
        try {
            int arrayIndex = Integer.parseInt(referenceToken);
            int arraySize = addOperation ? jsonArray.size() + 1 : jsonArray.size();
            this.validateArraySize(jsonArray, arrayIndex, arraySize);
            return arrayIndex;
        }
        catch (NumberFormatException e) {
            throw new JsonException("'" + referenceToken + "' is no valid array index", e);
        }
    }

    private void validateJsonPointer(JsonValue target, int size) throws NullPointerException, JsonException {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        JsonValue jsonValue = target;
        for (int i = 1; i < size; ++i) {
            jsonValue = this.getValue(jsonValue, this.referenceTokens.get(i), i, this.referenceTokens.size() - 1);
        }
    }

    private void validateArrayIndex(String referenceToken) throws JsonException {
        if (referenceToken.startsWith("+") || referenceToken.startsWith("-")) {
            throw new JsonException("An array index must not start with '" + referenceToken.charAt(0) + "'");
        }
        if (referenceToken.startsWith("0") && referenceToken.length() > 1) {
            throw new JsonException("An array index must not start with a leading '0'");
        }
    }

    private void validateArraySize(JsonArray jsonArray, int arrayIndex, int arraySize) throws JsonException {
        if (arrayIndex >= arraySize) {
            throw new JsonException("'" + jsonArray + "' contains no element for index " + arrayIndex);
        }
    }
}

