/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonNumber;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonString;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.org.apache.johnzon.core.JsonChars;
import org.talend.__shade__.org.apache.johnzon.core.SerializableValue;

final class JsonObjectImpl
extends AbstractMap<String, JsonValue>
implements JsonObject,
Serializable {
    private transient Integer hashCode = null;
    private final Map<String, JsonValue> unmodifieableBackingMap;

    private <T> T value(String name, Class<T> clazz) {
        JsonValue v = this.unmodifieableBackingMap.get(name);
        if (v != null) {
            return clazz.cast(v);
        }
        return null;
    }

    private <T> T valueOrExcpetion(String name, Class<T> clazz) {
        T value = this.value(name, clazz);
        if (value == null) {
            throw new NullPointerException("no mapping for " + name);
        }
        return value;
    }

    JsonObjectImpl(Map<String, JsonValue> backingMap) {
        this.unmodifieableBackingMap = new LinkedHashMap<String, JsonValue>(backingMap);
    }

    @Override
    public JsonArray getJsonArray(String name) {
        return this.value(name, JsonArray.class);
    }

    @Override
    public JsonObject getJsonObject(String name) {
        return this.value(name, JsonObject.class);
    }

    @Override
    public JsonNumber getJsonNumber(String name) {
        return this.value(name, JsonNumber.class);
    }

    @Override
    public JsonString getJsonString(String name) {
        return this.value(name, JsonString.class);
    }

    @Override
    public String getString(String name) {
        return this.valueOrExcpetion(name, JsonString.class).getString();
    }

    @Override
    public String getString(String name, String defaultValue) {
        JsonValue v = this.value(name, JsonValue.class);
        if (v != null && v instanceof JsonString) {
            return ((JsonString)JsonString.class.cast(v)).getString();
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name) {
        return this.valueOrExcpetion(name, JsonNumber.class).intValue();
    }

    @Override
    public int getInt(String name, int defaultValue) {
        JsonValue v = this.value(name, JsonValue.class);
        if (v != null && v instanceof JsonNumber) {
            return ((JsonNumber)JsonNumber.class.cast(v)).intValue();
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String name) {
        JsonValue obj = this.valueOrExcpetion(name, JsonValue.class);
        if (JsonValue.TRUE == obj) {
            return true;
        }
        if (JsonValue.FALSE == obj) {
            return false;
        }
        throw new ClassCastException("Wrong value for a boolean: " + obj);
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        JsonValue v = this.value(name, JsonValue.class);
        if (v != null) {
            return JsonValue.TRUE.equals(v) || !JsonValue.FALSE.equals(v) && defaultValue;
        }
        return defaultValue;
    }

    @Override
    public boolean isNull(String name) {
        return JsonValue.NULL.equals(this.valueOrExcpetion(name, JsonValue.class));
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        Iterator<Map.Entry<String, JsonValue>> it = this.unmodifieableBackingMap.entrySet().iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            Map.Entry<String, JsonValue> entry = it.next();
            builder.append('\"').append(entry.getKey()).append("\":");
            JsonValue value = entry.getValue();
            if (JsonString.class.isInstance(value)) {
                builder.append(value.toString());
            } else {
                builder.append(value != JsonValue.NULL ? value.toString() : JsonChars.NULL);
            }
            if (!(hasNext = it.hasNext())) continue;
            builder.append(",");
        }
        return builder.append('}').toString();
    }

    @Override
    public boolean equals(Object obj) {
        return JsonObjectImpl.class.isInstance(obj) && this.unmodifieableBackingMap.equals(((JsonObjectImpl)JsonObjectImpl.class.cast((Object)obj)).unmodifieableBackingMap);
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.unmodifieableBackingMap.hashCode());
        }
        return h;
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return this.unmodifieableBackingMap.entrySet();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializableValue(this.toString());
    }
}

