/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonNumber;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonString;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.stream.JsonLocation;
import org.talend.__shade__.javax.json.stream.JsonParser;
import org.talend.__shade__.org.apache.johnzon.core.JohnzonJsonParserImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonLocationImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonStringImpl;
import org.talend.__shade__.org.apache.johnzon.core.SimpleStack;

class JsonInMemoryParser
extends JohnzonJsonParserImpl {
    private final SimpleStack<Iterator<JsonParser.Event>> stack = new SimpleStack();
    private JsonParser.Event currentEvent;
    private JsonValue currentValue;
    private int arrayDepth = 0;

    @Override
    public JsonParser.Event current() {
        if (this.currentEvent == null && this.hasNext()) {
            this.next();
        }
        return this.currentEvent;
    }

    @Override
    protected boolean isInArray() {
        return this.arrayDepth > 0;
    }

    private static JsonParser.Event getEvent(JsonValue.ValueType value) {
        switch (value) {
            case NUMBER: {
                return JsonParser.Event.VALUE_NUMBER;
            }
            case STRING: {
                return JsonParser.Event.VALUE_STRING;
            }
            case FALSE: {
                return JsonParser.Event.VALUE_FALSE;
            }
            case NULL: {
                return JsonParser.Event.VALUE_NULL;
            }
            case TRUE: {
                return JsonParser.Event.VALUE_TRUE;
            }
        }
        throw new IllegalArgumentException((Object)((Object)value) + " not supported");
    }

    JsonInMemoryParser(JsonObject object) {
        this.stack.push(new ObjectIterator(object));
    }

    JsonInMemoryParser(JsonArray array) {
        this.stack.push(new ArrayIterator(array));
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public JsonParser.Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentEvent = this.stack.peek().next();
        if (this.currentEvent == JsonParser.Event.START_ARRAY) {
            ++this.arrayDepth;
        } else if (this.currentEvent == JsonParser.Event.END_ARRAY) {
            --this.arrayDepth;
        }
        return this.currentEvent;
    }

    @Override
    public String getString() {
        if (this.currentEvent != JsonParser.Event.KEY_NAME && this.currentEvent != JsonParser.Event.VALUE_STRING) {
            throw new IllegalStateException("String is for numbers and strings");
        }
        return ((JsonString)JsonString.class.cast(this.currentValue)).getString();
    }

    @Override
    public boolean isIntegralNumber() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("isIntegralNumber is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.currentValue)).isIntegral();
    }

    @Override
    public boolean isNotTooLong() {
        return true;
    }

    @Override
    public int getInt() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("getInt is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.currentValue)).intValue();
    }

    @Override
    public long getLong() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("getLong is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.currentValue)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal() {
        if (this.currentEvent != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("getBigDecimal is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.currentValue)).bigDecimalValue();
    }

    @Override
    public JsonLocation getLocation() {
        return JsonLocationImpl.UNKNOWN_LOCATION;
    }

    @Override
    public void close() {
    }

    private class ObjectIterator
    implements Iterator<JsonParser.Event> {
        private final Iterator<Map.Entry<String, JsonValue>> oentries;
        private JsonValue jsonValue;
        private Boolean end = null;

        public ObjectIterator(JsonObject jo) {
            this.oentries = jo.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return !Boolean.TRUE.equals(this.end);
        }

        @Override
        public JsonParser.Event next() {
            if (this.end == null) {
                this.end = Boolean.FALSE;
                return JsonParser.Event.START_OBJECT;
            }
            if (this.jsonValue == null && !this.oentries.hasNext()) {
                if (!JsonInMemoryParser.this.stack.isEmpty()) {
                    JsonInMemoryParser.this.stack.pop();
                }
                this.end = Boolean.TRUE;
                return JsonParser.Event.END_OBJECT;
            }
            if (this.jsonValue == null) {
                Map.Entry<String, JsonValue> tmp = this.oentries.next();
                this.jsonValue = tmp.getValue();
                JsonInMemoryParser.this.currentValue = new JsonStringImpl(tmp.getKey());
                return JsonParser.Event.KEY_NAME;
            }
            JsonValue.ValueType vt = this.jsonValue.getValueType();
            if (vt == JsonValue.ValueType.OBJECT) {
                JsonInMemoryParser.this.stack.push(new ObjectIterator((JsonObject)this.jsonValue));
                this.jsonValue = null;
                return (JsonParser.Event)((Object)((Iterator)JsonInMemoryParser.this.stack.peek()).next());
            }
            if (vt == JsonValue.ValueType.ARRAY) {
                JsonInMemoryParser.this.stack.push(new ArrayIterator((JsonArray)this.jsonValue));
                this.jsonValue = null;
                return (JsonParser.Event)((Object)((Iterator)JsonInMemoryParser.this.stack.peek()).next());
            }
            JsonParser.Event ret = JsonInMemoryParser.getEvent(vt);
            JsonInMemoryParser.this.currentValue = this.jsonValue;
            this.jsonValue = null;
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class ArrayIterator
    implements Iterator<JsonParser.Event> {
        private final Iterator<JsonValue> aentries;
        private Boolean end = null;

        public ArrayIterator(JsonArray ja) {
            this.aentries = ja.iterator();
        }

        @Override
        public boolean hasNext() {
            return !Boolean.TRUE.equals(this.end);
        }

        @Override
        public JsonParser.Event next() {
            if (this.end == null) {
                this.end = Boolean.FALSE;
                return JsonParser.Event.START_ARRAY;
            }
            if (!this.aentries.hasNext()) {
                if (!JsonInMemoryParser.this.stack.isEmpty()) {
                    JsonInMemoryParser.this.stack.pop();
                }
                this.end = Boolean.TRUE;
                return JsonParser.Event.END_ARRAY;
            }
            JsonValue val = this.aentries.next();
            JsonValue.ValueType vt = val.getValueType();
            if (vt == JsonValue.ValueType.OBJECT) {
                JsonInMemoryParser.this.stack.push(new ObjectIterator((JsonObject)val));
                return (JsonParser.Event)((Object)((Iterator)JsonInMemoryParser.this.stack.peek()).next());
            }
            if (vt == JsonValue.ValueType.ARRAY) {
                JsonInMemoryParser.this.stack.push(new ArrayIterator((JsonArray)val));
                return (JsonParser.Event)((Object)((Iterator)JsonInMemoryParser.this.stack.peek()).next());
            }
            JsonInMemoryParser.this.currentValue = val;
            return JsonInMemoryParser.getEvent(vt);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

