/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonArrayBuilder;
import org.talend.__shade__.javax.json.JsonException;
import org.talend.__shade__.javax.json.JsonObjectBuilder;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.org.apache.johnzon.core.JsonArrayImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonDoubleImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonLongImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonNumberImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonStringImpl;

class JsonArrayBuilderImpl
implements JsonArrayBuilder,
Serializable {
    private List<JsonValue> tmpList;

    public JsonArrayBuilderImpl() {
    }

    public JsonArrayBuilderImpl(JsonArray initialData) {
        this.tmpList = new ArrayList<JsonValue>(initialData);
    }

    public JsonArrayBuilderImpl(Collection<?> initialData) {
        this.tmpList = new ArrayList<JsonValue>();
        for (Object initialValue : initialData) {
            this.add(initialValue);
        }
    }

    @Override
    public JsonArrayBuilder addAll(JsonArrayBuilder builder) {
        builder.build().forEach(this::add);
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, JsonValue value) {
        this.addValue(index, value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, String value) {
        this.addValue(index, new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, BigDecimal value) {
        this.addValue(index, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, BigInteger value) {
        this.addValue(index, new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, int value) {
        this.addValue(index, new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, long value) {
        this.addValue(index, new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, double value) {
        this.addValue(index, new JsonDoubleImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, boolean value) {
        this.addValue(index, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull(int index) {
        this.addValue(index, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, JsonObjectBuilder builder) {
        this.addValue(index, builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(int index, JsonArrayBuilder builder) {
        this.addValue(index, builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, JsonValue value) {
        this.setValue(index, value);
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, String value) {
        this.setValue(index, new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, BigDecimal value) {
        this.setValue(index, new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, BigInteger value) {
        this.setValue(index, new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, int value) {
        this.setValue(index, new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, long value) {
        this.setValue(index, new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, double value) {
        this.setValue(index, new JsonDoubleImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, boolean value) {
        this.setValue(index, value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder setNull(int index) {
        this.setValue(index, JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, JsonObjectBuilder builder) {
        this.setValue(index, builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder set(int index, JsonArrayBuilder builder) {
        this.setValue(index, builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder remove(int index) {
        this.tmpList.remove(index);
        return this;
    }

    public JsonArrayBuilder add(Object value) {
        if (value instanceof JsonValue) {
            this.add((JsonValue)value);
        } else if (value instanceof BigDecimal) {
            this.add((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.add((BigInteger)value);
        } else if (value instanceof Boolean) {
            this.add((Boolean)value);
        } else if (value instanceof Double) {
            this.add((Double)value);
        } else if (value instanceof Integer) {
            this.add((Integer)value);
        } else if (value instanceof Long) {
            this.add((Long)value);
        } else if (value instanceof String) {
            this.add((String)value);
        } else {
            throw new JsonException("Illegal JSON type! type=" + value.getClass());
        }
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonValue value) {
        this.addValue(value);
        return this;
    }

    @Override
    public JsonArrayBuilder add(String value) {
        this.addValue(new JsonStringImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigDecimal value) {
        this.addValue(new JsonNumberImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(BigInteger value) {
        this.addValue(new JsonNumberImpl(new BigDecimal(value)));
        return this;
    }

    @Override
    public JsonArrayBuilder add(int value) {
        this.addValue(new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(long value) {
        this.addValue(new JsonLongImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(double value) {
        this.addValue(new JsonDoubleImpl(value));
        return this;
    }

    @Override
    public JsonArrayBuilder add(boolean value) {
        this.addValue(value ? JsonValue.TRUE : JsonValue.FALSE);
        return this;
    }

    @Override
    public JsonArrayBuilder addNull() {
        this.addValue(JsonValue.NULL);
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonObjectBuilder builder) {
        this.addValue(builder.build());
        return this;
    }

    @Override
    public JsonArrayBuilder add(JsonArrayBuilder builder) {
        this.addValue(builder.build());
        return this;
    }

    private void setValue(int idx, JsonValue value) {
        if (value == null || this.tmpList == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        this.tmpList.set(idx, value);
    }

    private void addValue(JsonValue value) {
        if (value == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<JsonValue>();
        }
        this.tmpList.add(value);
    }

    private void addValue(int idx, JsonValue value) {
        if (value == null) {
            throw JsonArrayBuilderImpl.npe();
        }
        if (this.tmpList == null) {
            this.tmpList = new ArrayList<JsonValue>();
        }
        this.tmpList.add(idx, value);
    }

    @Override
    public JsonArray build() {
        if (this.tmpList == null) {
            return new JsonArrayImpl(Collections.emptyList());
        }
        return new JsonArrayImpl(Collections.unmodifiableList(this.tmpList));
    }

    private static NullPointerException npe() {
        throw new NullPointerException("value/builder must not be null");
    }
}

