/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.schema;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.exception.ComponentException;
import org.talend.sdk.component.api.exception.DiscoverSchemaException;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.processor.OutputEmitter;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.di.AutoChunkProcessor;
import org.talend.sdk.component.runtime.di.InputsHandler;
import org.talend.sdk.component.runtime.di.JobStateAware;
import org.talend.sdk.component.runtime.di.OutputsHandler;
import org.talend.sdk.component.runtime.di.schema.Column;
import org.talend.sdk.component.runtime.di.schema.JavaType;
import org.talend.sdk.component.runtime.di.schema.JavaTypesManager;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.ServiceMeta;
import org.talend.sdk.component.runtime.manager.chain.ChainedMapper;
import org.talend.sdk.component.runtime.manager.xbean.converter.SchemaConverter;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;

public class TaCoKitGuessSchema {
    private static final Logger log = LoggerFactory.getLogger(TaCoKitGuessSchema.class);
    public static final String STRING_ESCAPE = "\"";
    public static final String NO_COMPONENT = "No component ";
    public static final String TCOMP_CONFIGURATIONTYPE_TYPE = "tcomp::configurationtype::type";
    public static final String DATASET = "dataset";
    public static final String ERROR_THROUGH_ACTION = "Can't guess schema through action.";
    public static final String ERROR_NO_AVAILABLE_SCHEMA_FOUND = "There is no available schema found.";
    public static final String ERROR_INSTANCE_SCHEMA = "Result is not an instance of Talend Component Kit Schema.";
    private static final String NO_COLUMN_FOUND_BY_GUESS_SCHEMA = "No column found by guess schema action";
    private ComponentManager componentManager;
    private JavaTypesManager javaTypesManager;
    private PrintStream out;
    private Map<String, Column> columns;
    private Map<String, String> configuration;
    private Map<Class, JavaType> class2JavaTypeMap;
    private Set<String> keysNoTypeYet;
    private final int lineLimit;
    private int lineCount;
    private String plugin;
    private String family;
    private String componentName;
    private String action;
    private final Integer version;
    private static final String SCHEMA_TYPE = "schema";
    private static final String SCHEMA_EXTENDED_TYPE = "schema_extended";
    private static final String EMPTY = "";

    public TaCoKitGuessSchema(PrintStream out, Map<String, String> configuration, String plugin, String family, String componentName, String action, String version) {
        this.out = out;
        this.lineLimit = 50;
        this.lineCount = -1;
        this.componentManager = ComponentManager.instance();
        this.componentManager.autoDiscoverPlugins(false, true);
        this.configuration = configuration;
        this.plugin = plugin;
        this.family = family;
        this.componentName = componentName;
        this.action = action;
        this.columns = new LinkedHashMap<String, Column>();
        this.keysNoTypeYet = new HashSet<String>();
        this.javaTypesManager = new JavaTypesManager();
        this.version = Optional.ofNullable(version).map(Integer::parseInt).orElse(null);
        this.initClass2JavaTypeMap();
    }

    public TaCoKitGuessSchema() {
        this.lineLimit = 50;
        this.version = null;
        this.javaTypesManager = new JavaTypesManager();
    }

    private void initClass2JavaTypeMap() {
        JavaType[] javaTypes;
        this.class2JavaTypeMap = new HashMap<Class, JavaType>();
        for (JavaType javaType : javaTypes = this.javaTypesManager.getJavaTypes()) {
            Class primitiveClass;
            Class nullableClass = javaType.getNullableClass();
            if (nullableClass != null) {
                this.class2JavaTypeMap.put(nullableClass, javaType);
            }
            if ((primitiveClass = javaType.getPrimitiveClass()) == null) continue;
            this.class2JavaTypeMap.put(primitiveClass, javaType);
        }
    }

    private DiscoverSchemaException transformException(Exception e) {
        DiscoverSchemaException discoverSchemaException = e instanceof DiscoverSchemaException ? (DiscoverSchemaException)DiscoverSchemaException.class.cast(e) : (e instanceof ComponentException ? new DiscoverSchemaException((ComponentException)e) : new DiscoverSchemaException(e.getMessage(), e.getStackTrace(), DiscoverSchemaException.HandleErrorWith.EXCEPTION));
        return discoverSchemaException;
    }

    private DiscoverSchemaException handleException(Exception e) throws Exception {
        log.error(ERROR_THROUGH_ACTION, (Throwable)e);
        DiscoverSchemaException discoverSchemaException = this.transformException(e);
        try (Jsonb jsonb = JsonbBuilder.create();){
            jsonb.toJson((Object)discoverSchemaException, (OutputStream)this.out);
        }
        return discoverSchemaException;
    }

    public void guessInputComponentSchema(Schema schema) throws Exception {
        try {
            if (this.guessSchemaThroughAction(schema)) {
                return;
            }
            if (this.guessInputComponentSchemaThroughResult()) {
                return;
            }
        }
        catch (Exception e) {
            throw this.handleException(e);
        }
        throw this.handleException(new Exception(ERROR_NO_AVAILABLE_SCHEMA_FOUND));
    }

    public void guessComponentSchema(Schema incomingSchema, String outgoingBranch, boolean isStartOfJob) throws Exception {
        try {
            this.executeDiscoverSchemaExtendedAction(incomingSchema, outgoingBranch);
        }
        catch (Exception e) {
            DiscoverSchemaException dse = this.transformException(e);
            if (isStartOfJob && DiscoverSchemaException.HandleErrorWith.EXECUTE_LIFECYCLE == dse.getPossibleHandleErrorWith()) {
                try {
                    this.guessOutputComponentSchemaThroughResult();
                }
                catch (Exception er) {
                    throw this.handleException(e);
                }
            }
            throw this.handleException(e);
        }
    }

    public void guessComponentSchema(Schema incomingSchema, String outgoingBranch) throws Exception {
        this.guessComponentSchema(incomingSchema, outgoingBranch, false);
    }

    private void executeDiscoverSchemaExtendedAction(Schema schema, String branch) throws Exception {
        Object schemaResult;
        Collection<ServiceMeta> services = this.getPluginServices();
        ServiceMeta.ActionMeta actionRef = services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getType().equals(SCHEMA_EXTENDED_TYPE) && this.componentName.equals(a.getAction())).findFirst().orElse(null);
        if (actionRef == null) {
            actionRef = services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getType().equals(SCHEMA_EXTENDED_TYPE)).findFirst().orElseThrow(() -> new IllegalArgumentException("No action " + this.family + "#" + SCHEMA_EXTENDED_TYPE));
        }
        if ((schemaResult = actionRef.getInvoker().apply(this.buildActionConfig(actionRef, this.configuration, schema, branch))) instanceof Schema) {
            Schema result = (Schema)schemaResult;
            if (result.getEntries().isEmpty()) {
                throw new DiscoverSchemaException(ERROR_NO_AVAILABLE_SCHEMA_FOUND, DiscoverSchemaException.HandleErrorWith.EXCEPTION);
            }
            this.fromSchema((Schema)Schema.class.cast(schemaResult));
        }
    }

    private Map<String, String> buildActionConfig(ServiceMeta.ActionMeta action, Map<String, String> configuration, Schema schema, String branch) {
        String schemaPath = ((List)action.getParameters().get()).stream().filter(p -> Schema.class.isAssignableFrom((Class)p.getJavaType())).map(p -> p.getPath()).findFirst().orElse(EMPTY);
        String branchPath = ((List)action.getParameters().get()).stream().filter(p -> String.class.isAssignableFrom((Class)p.getJavaType())).map(ParameterMeta::getPath).findFirst().orElse(EMPTY);
        HashMap<String, String> mapped = new HashMap<String, String>();
        if (!schemaPath.isEmpty()) {
            try (Jsonb jsonb = JsonbBuilder.create();){
                mapped.put(schemaPath, jsonb.toJson((Object)schema));
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
        }
        if (!branchPath.isEmpty()) {
            mapped.put(branchPath, branch);
        }
        if (configuration == null || configuration.isEmpty()) {
            return mapped;
        }
        String prefix = ((List)action.getParameters().get()).stream().filter(s -> !s.getPath().equals(schemaPath) && !s.getPath().equals(branchPath)).map(ParameterMeta::getPath).findFirst().orElse(null);
        if (prefix == null) {
            return mapped;
        }
        mapped.putAll(configuration.entrySet().stream().filter(e -> this.isChildParameter((String)e.getKey(), prefix) || prefix.equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        return mapped;
    }

    private Map<String, String> buildActionConfig(ServiceMeta.ActionMeta action, Map<String, String> configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return configuration;
        }
        String prefix = ((List)action.getParameters().get()).stream().filter(param -> param.getMetadata().containsKey(TCOMP_CONFIGURATIONTYPE_TYPE) && DATASET.equals(param.getMetadata().get(TCOMP_CONFIGURATIONTYPE_TYPE))).findFirst().map(ParameterMeta::getPath).orElse(null);
        if (prefix == null) {
            return configuration;
        }
        ParameterMeta dataSet = this.findDataset(action).orElseThrow(() -> new IllegalArgumentException("Dataset not found for " + action.getAction()));
        String dataSetPath = dataSet.getPath();
        return configuration.entrySet().stream().filter(e -> this.isChildParameter((String)e.getKey(), dataSetPath)).collect(Collectors.toMap(e -> prefix + ((String)e.getKey()).substring(dataSetPath.length()), Map.Entry::getValue));
    }

    private boolean isChildParameter(String path, String parentPath) {
        return path.startsWith(parentPath) && path.substring(parentPath.length()).startsWith(".");
    }

    private Optional<ParameterMeta> findDataset(ServiceMeta.ActionMeta action) {
        ComponentFamilyMeta familyMeta = this.findFamily();
        ComponentFamilyMeta.BaseMeta<?> componentMeta = this.findComponent(familyMeta);
        Collection metas = this.toStream((Collection)componentMeta.getParameterMetas().get()).collect(Collectors.toList());
        return Optional.ofNullable(metas.stream().filter(p -> DATASET.equals(p.getMetadata().get(TCOMP_CONFIGURATIONTYPE_TYPE)) && action.getAction().equals(p.getMetadata().get("tcomp::configurationtype::name"))).findFirst().orElseGet(() -> {
            Iterator iterator = metas.stream().filter(p -> DATASET.equals(p.getMetadata().get(TCOMP_CONFIGURATIONTYPE_TYPE))).iterator();
            if (iterator.hasNext()) {
                ParameterMeta value = (ParameterMeta)iterator.next();
                if (!iterator.hasNext()) {
                    return value;
                }
                log.warn("Multiple potential datasets for {}:{}, ignoring parameters", (Object)action.getType(), (Object)action.getAction());
            }
            return null;
        }));
    }

    private ComponentFamilyMeta.BaseMeta<?> findComponent(ComponentFamilyMeta familyMeta) {
        return Stream.concat(familyMeta.getPartitionMappers().entrySet().stream(), familyMeta.getProcessors().entrySet().stream()).filter(e -> ((String)e.getKey()).equals(this.componentName)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException(NO_COMPONENT + this.componentName));
    }

    private ComponentFamilyMeta findFamily() {
        return (ComponentFamilyMeta)((ContainerComponentRegistry)((Container)this.componentManager.findPlugin(this.plugin).orElseThrow(() -> new IllegalArgumentException("No component family " + this.plugin))).get(ContainerComponentRegistry.class)).getComponents().get(this.family);
    }

    private Stream<ParameterMeta> toStream(Collection<ParameterMeta> parameterMetas) {
        return Stream.concat(parameterMetas.stream(), parameterMetas.stream().map(ParameterMeta::getNestedParameters).filter(Objects::nonNull).flatMap(this::toStream));
    }

    private Optional<String> findFirstComponentDataSetName() {
        ComponentFamilyMeta familyMeta = this.findFamily();
        ComponentFamilyMeta.BaseMeta<?> componentMeta = this.findComponent(familyMeta);
        return this.toStream((Collection)componentMeta.getParameterMetas().get()).filter(p -> DATASET.equals(p.getMetadata().get(TCOMP_CONFIGURATIONTYPE_TYPE))).findFirst().map(p -> (String)p.getMetadata().get("tcomp::configurationtype::name"));
    }

    public boolean guessSchemaThroughAction(Schema schema) {
        ServiceMeta.ActionMeta actionRef;
        Collection<ServiceMeta> services = this.getPluginServices();
        if (this.action == null || this.action.isEmpty()) {
            actionRef = this.findFirstComponentDataSetName().flatMap(datasetName -> services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getType().equals(SCHEMA_TYPE)).filter(a -> a.getAction().equals(datasetName)).findFirst()).orElse(null);
            if (actionRef == null) {
                actionRef = this.findFirstComponentDataSetName().flatMap(datasetName -> services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getType().equals(SCHEMA_EXTENDED_TYPE)).filter(a -> a.getAction().equals(datasetName)).findFirst()).orElse(null);
            }
        } else {
            actionRef = services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getAction().equals(this.action) && a.getType().equals(SCHEMA_TYPE)).findFirst().orElseThrow(() -> new IllegalArgumentException("No action " + this.family + "#" + SCHEMA_TYPE + "#" + this.action));
        }
        if (actionRef == null) {
            return false;
        }
        Map<String, String> actionConfiguration = SCHEMA_TYPE.equals(actionRef.getType()) ? this.buildActionConfig(actionRef, this.configuration) : this.buildActionConfig(actionRef, this.configuration, schema, "INPUT");
        Object schemaResult = actionRef.getInvoker().apply(actionConfiguration);
        if (schemaResult instanceof Schema) {
            return this.fromSchema((Schema)Schema.class.cast(schemaResult));
        }
        log.error(ERROR_INSTANCE_SCHEMA);
        return false;
    }

    private Collection<ServiceMeta> getPluginServices() {
        return ((ContainerComponentRegistry)((Container)this.componentManager.findPlugin(this.plugin).orElseThrow(() -> new IllegalArgumentException(NO_COMPONENT + this.plugin))).get(ContainerComponentRegistry.class)).getServices();
    }

    private boolean fromSchema(Schema schema) {
        List entries = schema.getEntries();
        if (entries == null || entries.isEmpty()) {
            log.info(NO_COLUMN_FOUND_BY_GUESS_SCHEMA);
            return false;
        }
        Map<String, Column> map = this.getSchemaMap(schema);
        if (!map.isEmpty()) {
            this.columns.putAll(map);
        }
        return true;
    }

    public Collection<Column> getFixedSchema(String execute) {
        SchemaConverter sc = new SchemaConverter();
        Object o = sc.toObjectImpl(execute);
        if (o instanceof Schema) {
            Schema schema = (Schema)Schema.class.cast(o);
            List entries = schema.getEntries();
            if (entries == null || entries.isEmpty()) {
                log.info(NO_COLUMN_FOUND_BY_GUESS_SCHEMA);
                return Collections.emptyList();
            }
            Map<String, Column> map = this.getSchemaMap(schema);
            if (map != null) {
                return map.values();
            }
        }
        return Collections.emptyList();
    }

    private Map<String, Column> getSchemaMap(Schema schema) {
        LinkedHashMap<String, Column> schemaMap = new LinkedHashMap<String, Column>();
        List entries = schema.getEntries();
        if (entries == null || entries.isEmpty()) {
            log.info(NO_COLUMN_FOUND_BY_GUESS_SCHEMA);
            return Collections.emptyMap();
        }
        for (Schema.Entry entry : entries) {
            Column column = this.createColumnFromEntry(entry);
            schemaMap.put(entry.getName(), column);
        }
        return schemaMap;
    }

    private Column createColumnFromEntry(Schema.Entry entry) {
        Column column = new Column();
        column.setLabel(entry.getName());
        column.setOriginalDbColumnName(entry.getOriginalFieldName());
        Schema.Type entryType = entry.getType() != null ? entry.getType() : Schema.Type.STRING;
        String talendType = entry.getProps().getOrDefault("talend.studio.type", EMPTY);
        column.setTalendType(this.getTypeName(entryType, talendType));
        column.setNullable(entry.isNullable());
        column.setComment(entry.getComment());
        this.parseInteger((String)entry.getProps().get("field.size")).ifPresent(column::setLength);
        this.parseInteger((String)entry.getProps().get("field.scale")).ifPresent(column::setPrecision);
        Optional.ofNullable((String)entry.getProps().get("field.key")).ifPresent(value -> column.setKey(Boolean.parseBoolean(value)));
        if (entryType == Schema.Type.DATETIME || talendType.equals("id_Dynamic")) {
            column.setPattern(this.getPattern((String)entry.getProps().get("field.pattern")));
        }
        if (entry.getDefaultValue() != null) {
            column.setDefault(entry.getDefaultValue().toString());
        }
        return column;
    }

    private String getTypeName(Schema.Type entryType, String talendType) {
        HashMap<Schema.Type, String> typeMappings = new HashMap<Schema.Type, String>();
        typeMappings.put(Schema.Type.BOOLEAN, this.javaTypesManager.BOOLEAN.getId());
        typeMappings.put(Schema.Type.DOUBLE, this.javaTypesManager.DOUBLE.getId());
        typeMappings.put(Schema.Type.LONG, this.javaTypesManager.LONG.getId());
        typeMappings.put(Schema.Type.FLOAT, this.javaTypesManager.FLOAT.getId());
        typeMappings.put(Schema.Type.ARRAY, this.javaTypesManager.LIST.getId());
        typeMappings.put(Schema.Type.DECIMAL, this.javaTypesManager.BIGDECIMAL.getId());
        typeMappings.put(Schema.Type.DATETIME, this.javaTypesManager.DATE.getId());
        if (typeMappings.containsKey(entryType)) {
            return (String)typeMappings.get(entryType);
        }
        switch (entryType) {
            case INT: {
                return talendType.equals(this.javaTypesManager.SHORT.getId()) ? this.javaTypesManager.SHORT.getId() : this.javaTypesManager.INTEGER.getId();
            }
            case BYTES: {
                return talendType.equals("id_Byte") ? this.javaTypesManager.BYTE.getId() : this.javaTypesManager.BYTE_ARRAY.getId();
            }
            case RECORD: {
                if ("id_Dynamic".equals(talendType)) {
                    return "id_Dynamic";
                }
                if ("id_Document".equals(talendType)) {
                    return "id_Document";
                }
                return this.javaTypesManager.OBJECT.getId();
            }
        }
        if (talendType.equals(this.javaTypesManager.CHARACTER.getId())) {
            return this.javaTypesManager.CHARACTER.getId();
        }
        if (talendType.equals(this.javaTypesManager.BYTE.getId())) {
            return this.javaTypesManager.BYTE.getId();
        }
        return this.javaTypesManager.STRING.getId();
    }

    private Optional<Integer> parseInteger(String value) {
        if (value == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    private String getPattern(String pattern) {
        return STRING_ESCAPE + (pattern != null ? pattern : "dd-MM-yyyy") + STRING_ESCAPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void guessOutputComponentSchemaThroughResult() throws Exception {
        Integer version = Optional.ofNullable(this.version).orElse(Integer.MAX_VALUE);
        Map services = ((ComponentManager.AllServices)((Container)this.componentManager.findPlugin(this.plugin).get()).get(ComponentManager.AllServices.class)).getServices();
        Processor processorComponent = (Processor)this.componentManager.findProcessor(this.family, this.componentName, version.intValue(), this.configuration).orElseThrow(() -> new IllegalArgumentException("Can't find " + this.family + "#" + this.componentName));
        Jsonb jsonb = (Jsonb)services.get(Jsonb.class);
        AutoChunkProcessor processor = new AutoChunkProcessor(1, processorComponent);
        JobStateAware.init(processorComponent, new HashMap<String, Object>());
        try {
            processor.start();
            InputsHandler inputsHandler = new InputsHandler(jsonb, services);
            InputFactory inputFactory = inputsHandler.asInputFactory();
            OutputsHandler outputsHandler = new OutputsHandler(jsonb, services);
            outputsHandler.addConnection("FLOW", Object.class);
            OutputFactory outputFactory = outputsHandler.asOutputFactoryForGuessSchema();
            processor.onElement(inputFactory, outputFactory);
            Object row = outputsHandler.getValue("FLOW");
            if (row != null && Object.class == row.getClass()) {
                this.fromOutputEmitterPojo(processorComponent, "FLOW");
                return;
            }
            if (row != null) {
                this.guessSchemaThroughResult(row);
            }
        }
        finally {
            try {
                processor.stop();
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean guessInputComponentSchemaThroughResult() throws Exception {
        Integer version = Optional.ofNullable(this.version).orElse(Integer.MAX_VALUE);
        Mapper mapper = (Mapper)this.componentManager.findMapper(this.family, this.componentName, version.intValue(), this.configuration).orElseThrow(() -> new IllegalArgumentException("Can't find " + this.family + "#" + this.componentName));
        if (JobStateAware.class.isInstance(mapper)) {
            ((JobStateAware)JobStateAware.class.cast(mapper)).setState(new JobStateAware.State());
        }
        Input input = null;
        try {
            mapper.start();
            ChainedMapper chainedMapper = new ChainedMapper(mapper, mapper.split(mapper.assess()).iterator());
            chainedMapper.start();
            input = chainedMapper.create();
            input.start();
            Object rowObject = input.next();
            if (rowObject == null) {
                boolean bl = false;
                return bl;
            }
            if (rowObject instanceof Record) {
                boolean bl = this.fromSchema(((Record)Record.class.cast(rowObject)).getSchema());
                return bl;
            }
            if (rowObject instanceof Map) {
                boolean bl = this.guessInputSchemaThroughResults(input, (Map)rowObject);
                return bl;
            }
            if (rowObject instanceof Collection) {
                throw new Exception("Can't guess schema from a Collection");
            }
            boolean bl = this.guessSchemaThroughResultClass(rowObject.getClass());
            return bl;
        }
        finally {
            if (input != null) {
                try {
                    input.stop();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                mapper.stop();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean guessSchemaThroughResult(Object rowObject) throws Exception {
        if (rowObject instanceof Map) {
            return this.guessSchemaThroughResult((Map)rowObject);
        }
        if (rowObject instanceof Schema) {
            return this.fromSchema((Schema)Schema.class.cast(rowObject));
        }
        if (rowObject instanceof Record) {
            return this.fromSchema(((Record)Record.class.cast(rowObject)).getSchema());
        }
        if (rowObject instanceof Collection) {
            throw new Exception("Can't guess schema from a Collection");
        }
        return this.guessSchemaThroughResultClass(rowObject.getClass());
    }

    private boolean guessSchemaThroughResultClass(Class<?> rowClass) {
        int originalSize = this.columns.size();
        for (Field field : rowClass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            String name = field.getName();
            Column column = new Column();
            column.setLabel(name);
            column.setOriginalDbColumnName(name);
            column.setTalendType(this.getTalendType(field.getType()));
            column.setNullable(!field.getType().isPrimitive());
            this.columns.put(name, column);
        }
        return originalSize != this.columns.size();
    }

    private boolean guessInputSchemaThroughResults(Input input, Map<String, ?> rowObject) {
        this.keysNoTypeYet.clear();
        int originalSize = this.columns.size();
        Map row = rowObject;
        while (!this.guessSchemaThroughResult(row) && (row = (Map)input.next()) != null) {
        }
        for (String key : this.keysNoTypeYet) {
            Column column = new Column();
            column.setLabel(key);
            column.setOriginalDbColumnName(key);
            column.setTalendType(this.getTalendType(Object.class));
            column.setNullable(true);
            this.columns.put(key, column);
        }
        return originalSize != this.columns.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromOutputEmitterPojo(Processor processor, String outBranchName) {
        Object o = processor;
        while (Delegated.class.isInstance(o)) {
            o = ((Delegated)Delegated.class.cast(o)).getDelegate();
        }
        ClassLoader classLoader = o.getClass().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            Class clazz;
            Optional type = Stream.of(o.getClass().getMethods()).filter(m -> m.isAnnotationPresent(ElementListener.class)).flatMap(m -> IntStream.range(0, m.getParameterCount()).filter(i -> m.getParameters()[i].isAnnotationPresent(Output.class) && outBranchName.equals(m.getParameters()[i].getAnnotation(Output.class).value())).mapToObj(i -> m.getGenericParameterTypes()[i]).filter(t -> ParameterizedType.class.isInstance(t) && ((ParameterizedType)ParameterizedType.class.cast(t)).getRawType() == OutputEmitter.class && ((ParameterizedType)ParameterizedType.class.cast(t)).getActualTypeArguments().length == 1).map(p -> ((ParameterizedType)ParameterizedType.class.cast(p)).getActualTypeArguments()[0])).findFirst();
            if (type.isPresent() && Class.class.isInstance(type.get()) && (clazz = (Class)Class.class.cast(type.get())) != JsonObject.class) {
                this.guessSchemaThroughResultClass(clazz);
            }
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    private boolean guessSchemaThroughResult(Map<String, ?> rowObject) {
        if (rowObject == null) {
            return false;
        }
        if (this.keysNoTypeYet.isEmpty() && this.lineCount < 0) {
            this.keysNoTypeYet.addAll(rowObject.keySet());
            this.lineCount = 0;
        }
        if (this.lineLimit <= this.lineCount) {
            for (String key : this.keysNoTypeYet) {
                Column column = new Column();
                column.setLabel(key);
                column.setOriginalDbColumnName(key);
                column.setTalendType(this.getTalendType(Object.class));
                column.setNullable(true);
                this.columns.put(key, column);
            }
            this.keysNoTypeYet.clear();
            return true;
        }
        ++this.lineCount;
        Iterator<String> iter = this.keysNoTypeYet.iterator();
        while (iter.hasNext()) {
            String type;
            String key = iter.next();
            Object result = rowObject.get(key);
            if (result == null || (type = Record.class.isInstance(rowObject) ? this.getTalendType(Object.class) : (JsonObject.class.isInstance(rowObject) ? this.getTalendType((JsonValue)result) : this.getTalendType(result.getClass()))) == null || type.trim().isEmpty()) continue;
            Column column = new Column();
            column.setLabel(key);
            column.setOriginalDbColumnName(key);
            column.setTalendType(type);
            column.setNullable(true);
            this.columns.put(key, column);
            iter.remove();
        }
        return this.keysNoTypeYet.isEmpty();
    }

    public synchronized void close() {
        if (!this.columns.isEmpty()) {
            try (Jsonb jsonb = JsonbBuilder.create();){
                jsonb.toJson(this.columns.values(), (OutputStream)this.out);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.out.flush();
            this.columns = new LinkedHashMap<String, Column>();
        }
    }

    protected String getTalendType(JsonValue value) {
        switch (value.getValueType()) {
            case TRUE: 
            case FALSE: {
                return this.javaTypesManager.BOOLEAN.getId();
            }
            case NUMBER: {
                Number number = ((JsonNumber)JsonNumber.class.cast(value)).numberValue();
                if (Long.class.isInstance(number)) {
                    return this.javaTypesManager.LONG.getId();
                }
                if (BigDecimal.class.isInstance(number)) {
                    return this.javaTypesManager.BIGDECIMAL.getId();
                }
                return this.javaTypesManager.DOUBLE.getId();
            }
            case STRING: {
                return this.javaTypesManager.STRING.getId();
            }
            case NULL: {
                return EMPTY;
            }
        }
        return this.javaTypesManager.OBJECT.getId();
    }

    private String getTalendType(Class type) {
        if (type == null) {
            return this.javaTypesManager.OBJECT.getId();
        }
        JavaType javaType = this.class2JavaTypeMap.get(type);
        if (javaType != null) {
            return javaType.getId();
        }
        return this.javaTypesManager.OBJECT.getId();
    }
}

