/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di;

import java.util.Map;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.di.BaseIOHandler;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.record.RecordConverters;

public class InputsHandler
extends BaseIOHandler {
    private final RecordConverters.MappingMetaRegistry registry = new RecordConverters.MappingMetaRegistry();

    public InputsHandler(Jsonb jsonb, Map<Class<?>, Object> servicesMapper) {
        super(jsonb, servicesMapper);
    }

    public InputFactory asInputFactory() {
        return name -> {
            String convertedValue;
            BaseIOHandler.IO ref = (BaseIOHandler.IO)this.connections.get(this.getActualName(name));
            if (ref == null || !ref.hasNext()) {
                return null;
            }
            Object value = ref.next();
            if (value instanceof Record) {
                return value;
            }
            RecordConverters.MappingMeta mappingMeta = this.registry.find(value.getClass());
            if (mappingMeta.isLinearMapping()) {
                return mappingMeta.newRecord(value, this.recordBuilderMapper);
            }
            if (value instanceof JsonValue) {
                if (JsonValue.NULL == value) {
                    return null;
                }
                convertedValue = value.toString();
            } else {
                convertedValue = this.jsonb.toJson(value);
            }
            return this.converters.toRecord(this.registry, (Object)convertedValue, () -> this.jsonb, () -> this.recordBuilderMapper);
        };
    }

    public <T> void initInputValue(String name, T value) {
        this.addConnection(name, value.getClass());
        this.setInputValue(value.getClass().getSimpleName(), value);
    }

    public <T> void setInputValue(String name, T value) {
        BaseIOHandler.IO input = (BaseIOHandler.IO)this.connections.get(this.getActualName(name));
        if (input != null) {
            input.add(value);
        }
    }
}

