/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.schema;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.talend.sdk.component.runtime.di.schema.JavaType;

public class JavaTypesManager {
    public static final String DEFAULT_CHAR = "' '";
    public static final String DEFAULT_BOOLEAN = "false";
    public static final String ANOTHER_BOOLEAN = "true";
    public static final String DEFAULT_NUMBER = "0";
    public static final String DEFAULT_STRING = "";
    public static final String NULL = "null";
    public static final String JAVA_PRIMITIVE_CHAR = "char";
    public static final String JAVA_PRIMITIVE_BOOLEAN = "boolean";
    public final JavaType BOOLEAN = new JavaType(Boolean.class, Boolean.TYPE);
    public final JavaType BYTE = new JavaType(Byte.class, Byte.TYPE);
    public final JavaType BYTE_ARRAY = new JavaType(byte[].class, false, false);
    public final JavaType CHARACTER = new JavaType(Character.class, Character.TYPE);
    public final JavaType DATE = new JavaType(Date.class, true, false);
    public final JavaType FILE = new JavaType(String.class, true, "File");
    public final JavaType DIRECTORY = new JavaType(String.class, true, "Directory");
    public final JavaType VALUE_LIST = new JavaType(String.class, true, "java.util.List Of Value");
    public final JavaType DOUBLE = new JavaType(Double.class, Double.TYPE);
    public final JavaType FLOAT = new JavaType(Float.class, Float.TYPE);
    public final JavaType INTEGER = new JavaType(Integer.class, Integer.TYPE);
    public final JavaType LONG = new JavaType(Long.class, Long.TYPE);
    public final JavaType SHORT = new JavaType(Short.class, Short.TYPE);
    public final JavaType STRING = new JavaType(String.class, false, false);
    public final JavaType OBJECT = new JavaType(Object.class, false, true);
    public final JavaType DYNAMIC = new JavaType(Object.class, false, true);
    public final JavaType LIST = new JavaType(List.class, false, true);
    public final JavaType BIGDECIMAL = new JavaType(BigDecimal.class, false, true);
    public final JavaType PASSWORD = new JavaType(String.class, true, "Password");
    public final JavaType[] JAVA_TYPES = new JavaType[]{this.BOOLEAN, this.BYTE, this.BYTE_ARRAY, this.CHARACTER, this.DATE, this.DOUBLE, this.FLOAT, this.BIGDECIMAL, this.INTEGER, this.LONG, this.OBJECT, this.SHORT, this.STRING, this.LIST};
    public final String[] NUMBERS = new String[]{this.INTEGER.getId(), this.FLOAT.getId(), this.DOUBLE.getId(), this.LONG.getId(), this.SHORT.getId(), this.BIGDECIMAL.getId(), this.BYTE.getId()};
    private final List<String> JAVA_PRIMITIVE_TYPES = new ArrayList<String>();
    private final Set<String> PRIMITIVE_TYPES_SET = new HashSet<String>(this.JAVA_PRIMITIVE_TYPES);
    private Map<String, JavaType> shortNameToJavaType;
    private Map<String, JavaType> canonicalClassNameToJavaType;
    private Map<String, JavaType> labelToJavaType;
    private Map<String, JavaType> idToJavaType;
    private List<JavaType> javaTypes;

    public JavaTypesManager() {
        this.init();
    }

    private void init() {
        this.shortNameToJavaType = new HashMap<String, JavaType>();
        this.labelToJavaType = new HashMap<String, JavaType>();
        this.idToJavaType = new HashMap<String, JavaType>();
        this.canonicalClassNameToJavaType = new HashMap<String, JavaType>();
        this.javaTypes = new ArrayList<JavaType>();
        for (JavaType javaType : this.JAVA_TYPES) {
            this.addJavaType(javaType);
        }
        this.idToJavaType.put(this.PASSWORD.getId(), this.PASSWORD);
    }

    public void addJavaType(JavaType javaType) {
        String primitiveName = null;
        Class primitiveClass = javaType.getPrimitiveClass();
        if (primitiveClass != null) {
            primitiveName = primitiveClass.getSimpleName();
            this.shortNameToJavaType.put(primitiveName, javaType);
            this.canonicalClassNameToJavaType.put(primitiveClass.getCanonicalName(), javaType);
            this.JAVA_PRIMITIVE_TYPES.add(primitiveClass.getSimpleName());
        }
        String nullableName = javaType.getNullableClass().getSimpleName();
        if (this.idToJavaType.keySet().contains(javaType.getId())) {
            return;
        }
        this.shortNameToJavaType.put(nullableName, javaType);
        this.canonicalClassNameToJavaType.put(javaType.getNullableClass().getCanonicalName(), javaType);
        this.labelToJavaType.put(javaType.getLabel(), javaType);
        this.idToJavaType.put(javaType.getId(), javaType);
        this.javaTypes.add(javaType);
    }

    public JavaType getJavaTypeFromName(String typeName) {
        return this.shortNameToJavaType.get(typeName);
    }

    public String getShortNameFromJavaType(JavaType javaType) {
        Class primitiveClass = javaType.getPrimitiveClass();
        if (primitiveClass != null) {
            return primitiveClass.getSimpleName();
        }
        return javaType.getNullableClass().getSimpleName();
    }

    public JavaType getJavaTypeFromLabel(String label) {
        return this.labelToJavaType.get(label);
    }

    public JavaType getJavaTypeFromId(String id) {
        JavaType javaTypeFromId = this.idToJavaType.get(id);
        if (javaTypeFromId == null) {
            throw new IllegalArgumentException("Unknown java id type : '" + id + "'");
        }
        return javaTypeFromId;
    }

    public JavaType[] getJavaTypes() {
        return this.javaTypes.toArray(new JavaType[0]);
    }

    public JavaType getJavaTypeFromCanonicalName(String canonicalName) {
        return this.canonicalClassNameToJavaType.get(canonicalName);
    }

    public String getTypeToGenerate(String idType, boolean nullable) {
        JavaType javaTypeFromId = this.getJavaTypeFromId(idType);
        return this.getTypeToGenerate(javaTypeFromId, nullable);
    }

    public String getTypeToGenerate(JavaType javaType, boolean nullable) {
        if (javaType == null) {
            return null;
        }
        Class primitiveClass = javaType.getPrimitiveClass();
        Class nullableClass = javaType.getNullableClass();
        if (nullable) {
            if (javaType.isGenerateWithCanonicalName()) {
                return nullableClass.getCanonicalName();
            }
            return nullableClass.getSimpleName();
        }
        if (primitiveClass != null) {
            return javaType.getPrimitiveClass().getSimpleName();
        }
        if (javaType.isGenerateWithCanonicalName()) {
            return nullableClass.getCanonicalName();
        }
        return nullableClass.getSimpleName();
    }

    public boolean isJavaPrimitiveType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return this.PRIMITIVE_TYPES_SET.contains(type);
    }

    public boolean isJavaPrimitiveType(String idType, boolean nullable) {
        String typeToGenerate = this.getTypeToGenerate(idType, nullable);
        return this.isJavaPrimitiveType(typeToGenerate);
    }

    public boolean isJavaPrimitiveType(JavaType javaType, boolean nullable) {
        String typeToGenerate = this.getTypeToGenerate(javaType, nullable);
        return this.isJavaPrimitiveType(typeToGenerate);
    }

    public boolean isNumberType(JavaType javaType) {
        return Number.class.isAssignableFrom(javaType.getNullableClass());
    }

    public boolean isNumberIntType(JavaType javaType) {
        return javaType == this.BYTE || javaType == this.INTEGER || javaType == this.SHORT || javaType == this.LONG;
    }

    public String getDefaultValueFromJavaType(String type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (this.isJavaPrimitiveType(type)) {
            if (type.equals(JAVA_PRIMITIVE_CHAR)) {
                return DEFAULT_CHAR;
            }
            if (type.equals(JAVA_PRIMITIVE_BOOLEAN)) {
                return DEFAULT_BOOLEAN;
            }
            return DEFAULT_NUMBER;
        }
        return NULL;
    }

    public String getDefaultValueFromJavaType(String type, String defaultValue) {
        if (defaultValue != null && defaultValue.length() > 0) {
            return defaultValue;
        }
        return this.getDefaultValueFromJavaType(type);
    }

    public String getDefaultValueFromJavaIdType(String idType, boolean nullable) {
        String typeToGenerate = this.getTypeToGenerate(idType, nullable);
        return this.getDefaultValueFromJavaType(typeToGenerate);
    }

    public String getDefaultValueFromJavaIdType(String idType, boolean nullable, String defaultValue) {
        String typeToGenerate = this.getTypeToGenerate(idType, nullable);
        return this.getDefaultValueFromJavaType(typeToGenerate, defaultValue);
    }

    public JavaType getDefaultJavaType() {
        return this.STRING;
    }

    public boolean isString(String type) {
        return this.STRING.getId().equals(type);
    }

    public boolean isBoolean(String type) {
        return this.BOOLEAN.getId().equals(type);
    }
}

