/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam;

import java.lang.instrument.ClassFileTransformer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.beam.spi.BeamComponentExtension;
import org.talend.sdk.component.runtime.di.beam.components.QueueMapper;
import org.talend.sdk.component.runtime.di.beam.components.QueueOutput;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.spi.component.ComponentExtension;

public class BeamDiExtension
implements ComponentExtension {
    private ComponentExtension delegate;

    public int priority() {
        return this.delegate.priority() - 1;
    }

    public boolean isActive() {
        try {
            this.delegate = new BeamComponentExtension(){

                public <T> T convert(ComponentExtension.ComponentInstance instance, Class<T> component) {
                    return (T)BeamDiExtension.this.doConvert(instance, component);
                }
            };
        }
        catch (NoClassDefFoundError | RuntimeException e) {
            return false;
        }
        return this.delegate.isActive();
    }

    private <T> T doConvert(ComponentExtension.ComponentInstance instance, Class<T> component) {
        if (Mapper.class == component) {
            PTransform begin = (PTransform)instance.instance();
            return component.cast(new QueueMapper(instance.plugin(), instance.family(), instance.name(), (PTransform<PBegin, PCollection<Record>>)begin));
        }
        if (Processor.class == component) {
            PTransform transform = (PTransform)instance.instance();
            return component.cast(new QueueOutput(instance.plugin(), instance.family(), instance.name(), transform));
        }
        throw new IllegalArgumentException("unsupported " + component + " by " + this.getClass());
    }

    public <T> T unwrap(Class<T> type, Object ... args) {
        return (T)this.delegate.unwrap(type, args);
    }

    public Collection<ClassFileTransformer> getTransformers() {
        return Collections.emptyList();
    }

    public void onComponent(ComponentExtension.ComponentContext context) {
        this.delegate.onComponent(context);
    }

    public boolean supports(Class<?> componentType) {
        return this.delegate.supports(componentType);
    }

    public Map<Class<?>, Object> getExtensionServices(String plugin) {
        return this.delegate.getExtensionServices(plugin);
    }

    public <T> T convert(ComponentExtension.ComponentInstance instance, Class<T> component) {
        return (T)this.delegate.convert(instance, component);
    }

    public Collection<String> getAdditionalDependencies() {
        return this.delegate.getAdditionalDependencies();
    }
}

