/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam;

import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.di.beam.SettableSourceListener;
import org.talend.sdk.component.runtime.di.beam.SourceListener;

public class DelegatingBoundedSource<T>
extends BoundedSource<T>
implements SettableSourceListener {
    private static final Logger log = LoggerFactory.getLogger(DelegatingBoundedSource.class);
    private BoundedSource<T> delegate;
    private SourceListener listener;

    public List<? extends BoundedSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        List sources = this.delegate.split(desiredBundleSizeBytes, options);
        this.listener.onSplit(sources.size());
        log.debug("Split {} in {} sources ({})", new Object[]{this.delegate, sources.size(), sources});
        return sources.stream().map(s -> new DelegatingBoundedSource<T>(s, this.listener)).collect(Collectors.toList());
    }

    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        return this.delegate.getEstimatedSizeBytes(options);
    }

    public BoundedSource.BoundedReader<T> createReader(PipelineOptions options) throws IOException {
        BoundedSource.BoundedReader boundedReader = this.delegate.createReader(options);
        DelegatingBoundedReader reader = new DelegatingBoundedReader(this, boundedReader, this.listener);
        log.debug("Creating reader {} from source {}", (Object)boundedReader, this.delegate);
        return reader;
    }

    public void validate() {
        this.delegate.validate();
    }

    @Deprecated
    public Coder<T> getDefaultOutputCoder() {
        return this.delegate.getDefaultOutputCoder();
    }

    public Coder<T> getOutputCoder() {
        return this.delegate.getOutputCoder();
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        this.delegate.populateDisplayData(builder);
    }

    @Override
    public void setSourceListener(SourceListener listener) {
        this.listener = listener;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DelegatingBoundedSource that = (DelegatingBoundedSource)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public DelegatingBoundedSource() {
    }

    public DelegatingBoundedSource(BoundedSource<T> delegate, SourceListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public static class DelegatingBoundedReader<T>
    extends BoundedSource.BoundedReader<T> {
        private BoundedSource<T> source;
        private BoundedSource.BoundedReader<T> delegate;
        private SourceListener listener;

        public Double getFractionConsumed() {
            return this.delegate.getFractionConsumed();
        }

        public long getSplitPointsConsumed() {
            return this.delegate.getSplitPointsConsumed();
        }

        public long getSplitPointsRemaining() {
            return this.delegate.getSplitPointsRemaining();
        }

        public BoundedSource<T> getCurrentSource() {
            return this.source;
        }

        public BoundedSource<T> splitAtFraction(double fraction) {
            BoundedSource newSource = this.delegate.splitAtFraction(fraction);
            if (newSource != null) {
                this.listener.onSplit(1);
                log.debug("Split at fraction {} reader {} and got source {}", new Object[]{fraction, this.delegate, newSource});
                return new DelegatingBoundedSource<T>(newSource, this.listener){};
            }
            return null;
        }

        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.delegate.getCurrentTimestamp();
        }

        public boolean start() throws IOException {
            return this.delegate.start();
        }

        public boolean advance() throws IOException {
            return this.delegate.advance();
        }

        public T getCurrent() throws NoSuchElementException {
            this.listener.onElement();
            return (T)this.delegate.getCurrent();
        }

        public void close() throws IOException {
            try {
                this.delegate.close();
            }
            finally {
                log.debug("Closing reader {} of source {}", this.delegate, (Object)this.delegate.getCurrentSource());
                this.listener.onReaderClose();
            }
        }

        public DelegatingBoundedReader() {
        }

        public DelegatingBoundedReader(BoundedSource<T> source, BoundedSource.BoundedReader<T> delegate, SourceListener listener) {
            this.source = source;
            this.delegate = delegate;
            this.listener = listener;
        }
    }
}

