/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.di.beam.LoopState;

public interface SourceListener
extends Serializable {
    public static final Map<String, Tracker> TRACKERS = new ConcurrentHashMap<String, Tracker>();

    public void onSplit(int var1);

    public void onElement();

    public void onReaderClose();

    public static class StateReleaserSourceListener
    implements SourceListener {
        private static final Logger log = LoggerFactory.getLogger(StateReleaserSourceListener.class);
        private String trackerId;
        private String stateId;
        private volatile LoopState state;
        private volatile Tracker tracker;

        @Override
        public void onSplit(int count) {
            this.getTracker().getActive().addAndGet(count);
        }

        @Override
        public void onElement() {
            this.getState().getRecordCount().incrementAndGet();
        }

        @Override
        public void onReaderClose() {
            int stillActive = this.getTracker().getActive().decrementAndGet();
            log.debug("Active sources: {}", (Object)stillActive);
            if (stillActive == 0) {
                TRACKERS.remove(this.trackerId);
                LoopState state = this.getState();
                state.done();
                if (state.getRecordCount().get() == 0L) {
                    state.end();
                }
            }
        }

        private Tracker getTracker() {
            return this.tracker == null ? (this.tracker = (Tracker)TRACKERS.get(this.trackerId)) : this.tracker;
        }

        private synchronized LoopState getState() {
            return this.state == null ? (this.state = LoopState.lookup(this.stateId)) : this.state;
        }

        public String getTrackerId() {
            return this.trackerId;
        }

        public String getStateId() {
            return this.stateId;
        }

        public void setTrackerId(String trackerId) {
            this.trackerId = trackerId;
        }

        public void setStateId(String stateId) {
            this.stateId = stateId;
        }

        public void setState(LoopState state) {
            this.state = state;
        }

        public void setTracker(Tracker tracker) {
            this.tracker = tracker;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StateReleaserSourceListener)) {
                return false;
            }
            StateReleaserSourceListener other = (StateReleaserSourceListener)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$trackerId = this.getTrackerId();
            String other$trackerId = other.getTrackerId();
            if (this$trackerId == null ? other$trackerId != null : !this$trackerId.equals(other$trackerId)) {
                return false;
            }
            String this$stateId = this.getStateId();
            String other$stateId = other.getStateId();
            if (this$stateId == null ? other$stateId != null : !this$stateId.equals(other$stateId)) {
                return false;
            }
            LoopState this$state = this.getState();
            LoopState other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            Tracker this$tracker = this.getTracker();
            Tracker other$tracker = other.getTracker();
            return !(this$tracker == null ? other$tracker != null : !((Object)this$tracker).equals(other$tracker));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StateReleaserSourceListener;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $trackerId = this.getTrackerId();
            result = result * 59 + ($trackerId == null ? 43 : $trackerId.hashCode());
            String $stateId = this.getStateId();
            result = result * 59 + ($stateId == null ? 43 : $stateId.hashCode());
            LoopState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            Tracker $tracker = this.getTracker();
            result = result * 59 + ($tracker == null ? 43 : ((Object)$tracker).hashCode());
            return result;
        }

        public String toString() {
            return "SourceListener.StateReleaserSourceListener(trackerId=" + this.getTrackerId() + ", stateId=" + this.getStateId() + ", state=" + this.getState() + ", tracker=" + this.getTracker() + ")";
        }

        public StateReleaserSourceListener() {
        }

        public StateReleaserSourceListener(String trackerId, String stateId, LoopState state, Tracker tracker) {
            this.trackerId = trackerId;
            this.stateId = stateId;
            this.state = state;
            this.tracker = tracker;
        }
    }

    public static class Tracker {
        private final String id = UUID.randomUUID().toString();
        private final AtomicInteger active = new AtomicInteger(0);

        public String getId() {
            return this.id;
        }

        public AtomicInteger getActive() {
            return this.active;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tracker)) {
                return false;
            }
            Tracker other = (Tracker)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            AtomicInteger this$active = this.getActive();
            AtomicInteger other$active = other.getActive();
            return !(this$active == null ? other$active != null : !this$active.equals(other$active));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Tracker;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            AtomicInteger $active = this.getActive();
            result = result * 59 + ($active == null ? 43 : $active.hashCode());
            return result;
        }

        public String toString() {
            return "SourceListener.Tracker(id=" + this.getId() + ", active=" + this.getActive() + ")";
        }
    }
}

