/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.beam;

import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.record.RecordConverters;

public class LoopState
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LoopState.class);
    private static final Map<String, LoopState> STATES = new ConcurrentHashMap<String, LoopState>();
    final AtomicInteger referenceCounting = new AtomicInteger();
    final String id = UUID.randomUUID().toString();
    final String plugin;
    private final Queue<Record> queue = new ConcurrentLinkedQueue<Record>();
    private final Semaphore semaphore = new Semaphore(0);
    private final AtomicLong recordCount = new AtomicLong(0L);
    private volatile RecordConverters recordConverters;
    private volatile RecordConverters.MappingMetaRegistry registry;
    private volatile Jsonb jsonb;
    private volatile RecordBuilderFactory recordBuilderFactory;
    private volatile boolean done;

    LoopState(String plugin) {
        this.plugin = plugin;
        STATES.putIfAbsent(this.id, this);
    }

    public void push(Object value) {
        if (value == null) {
            return;
        }
        this.queue.add(Record.class.isInstance(value) ? (Record)Record.class.cast(value) : this.toRecord(value));
        this.semaphore.release();
    }

    public Record next() {
        try {
            this.semaphore.acquire();
            return this.queue.poll();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public synchronized void done() {
        this.done = true;
    }

    public void end() {
        log.debug("Ending state {}", (Object)this.id);
        this.done();
        this.semaphore.release();
    }

    @Override
    public void close() {
        Optional.ofNullable(STATES.remove(this.id)).ifPresent(v -> {
            log.debug("Closing state {}", (Object)this.id);
            if (!this.done) {
                this.end();
            }
            Optional.ofNullable(this.jsonb).ifPresent(j -> {
                try {
                    j.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        });
    }

    public static LoopState newTracker(String plugin) {
        return new LoopState(plugin);
    }

    public static LoopState lookup(String stateId) {
        return STATES.get(stateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Record toRecord(Object value) {
        if (this.recordConverters == null) {
            LoopState loopState = this;
            synchronized (loopState) {
                if (this.recordConverters == null) {
                    ComponentManager manager = ComponentManager.instance();
                    this.jsonb = manager.getJsonbProvider().create().withProvider(manager.getJsonpProvider()).withConfig(new JsonbConfig().setProperty("johnzon.cdi.activated", (Object)false)).build();
                    this.recordConverters = new RecordConverters();
                    this.registry = new RecordConverters.MappingMetaRegistry();
                    this.recordBuilderFactory = (RecordBuilderFactory)manager.getRecordBuilderFactoryProvider().apply(null);
                }
            }
        }
        return this.recordConverters.toRecord(this.registry, value, () -> this.jsonb, () -> this.recordBuilderFactory);
    }

    public String getId() {
        return this.id;
    }

    public AtomicLong getRecordCount() {
        return this.recordCount;
    }
}

