/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.di.schema;

import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.processor.OutputEmitter;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.di.JobStateAware;
import org.talend.sdk.component.runtime.di.schema.Column;
import org.talend.sdk.component.runtime.di.schema.JavaType;
import org.talend.sdk.component.runtime.di.schema.JavaTypesManager;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.ServiceMeta;
import org.talend.sdk.component.runtime.manager.chain.ChainedMapper;
import org.talend.sdk.component.runtime.output.Processor;

public class TaCoKitGuessSchema {
    private static final Logger log = LoggerFactory.getLogger(TaCoKitGuessSchema.class);
    public static final String STRING_ESCAPE = "\"";
    private ComponentManager componentManager;
    private JavaTypesManager javaTypesManager;
    private PrintStream out;
    private Map<String, Column> columns;
    private Map<String, String> configuration;
    private Map<Class, JavaType> class2JavaTypeMap;
    private Set<String> keysNoTypeYet;
    private final int lineLimit;
    private int lineCount;
    private String plugin;
    private String family;
    private String componentName;
    private String action;
    private final String type = "schema";
    private static final String EMPTY = "";

    public TaCoKitGuessSchema(PrintStream out, Map<String, String> configuration, String plugin, String family, String componentName, String action) {
        this.out = out;
        this.lineLimit = 50;
        this.lineCount = -1;
        this.componentManager = ComponentManager.instance();
        this.componentManager.autoDiscoverPlugins(false, true);
        this.configuration = configuration;
        this.plugin = plugin;
        this.family = family;
        this.componentName = componentName;
        this.action = action;
        this.columns = new LinkedHashMap<String, Column>();
        this.keysNoTypeYet = new HashSet<String>();
        this.javaTypesManager = new JavaTypesManager();
        this.initClass2JavaTypeMap();
    }

    private void initClass2JavaTypeMap() {
        JavaType[] javaTypes;
        this.class2JavaTypeMap = new HashMap<Class, JavaType>();
        for (JavaType javaType : javaTypes = this.javaTypesManager.getJavaTypes()) {
            Class primitiveClass;
            Class nullableClass = javaType.getNullableClass();
            if (nullableClass != null) {
                this.class2JavaTypeMap.put(nullableClass, javaType);
            }
            if ((primitiveClass = javaType.getPrimitiveClass()) == null) continue;
            this.class2JavaTypeMap.put(primitiveClass, javaType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromOutputEmitterPojo(Processor processor, String outBranchName) {
        Object o = processor;
        while (Delegated.class.isInstance(o)) {
            o = ((Delegated)Delegated.class.cast(o)).getDelegate();
        }
        ClassLoader classLoader = o.getClass().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            Class clazz;
            Optional type = Stream.of(o.getClass().getMethods()).filter(m -> m.isAnnotationPresent(ElementListener.class)).flatMap(m -> IntStream.range(0, m.getParameterCount()).filter(i -> m.getParameters()[i].isAnnotationPresent(Output.class) && outBranchName.equals(m.getParameters()[i].getAnnotation(Output.class).value())).mapToObj(i -> m.getGenericParameterTypes()[i]).filter(t -> ParameterizedType.class.isInstance(t) && ((ParameterizedType)ParameterizedType.class.cast(t)).getRawType() == OutputEmitter.class && ((ParameterizedType)ParameterizedType.class.cast(t)).getActualTypeArguments().length == 1).map(p -> ((ParameterizedType)ParameterizedType.class.cast(p)).getActualTypeArguments()[0])).findFirst();
            if (type.isPresent() && Class.class.isInstance(type.get()) && (clazz = (Class)Class.class.cast(type.get())) != JsonObject.class) {
                this.guessSchemaThroughResultClass(clazz);
            }
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    public void guessInputComponentSchema() throws Exception {
        try {
            if (this.guessSchemaThroughAction()) {
                return;
            }
        }
        catch (Exception e) {
            log.error("Can't guess schema through action.", (Throwable)e);
        }
        if (this.guessInputComponentSchemaThroughResult()) {
            return;
        }
        throw new Exception("There is no available schema found.");
    }

    private Map<String, String> buildActionConfig(ServiceMeta.ActionMeta action, Map<String, String> configuration) {
        if (configuration == null || configuration.isEmpty()) {
            return configuration;
        }
        String prefix = ((List)action.getParameters().get()).stream().filter(param -> param.getMetadata().containsKey("tcomp::configurationtype::type") && "dataset".equals(param.getMetadata().get("tcomp::configurationtype::type"))).findFirst().map(ParameterMeta::getPath).orElse(null);
        if (prefix == null) {
            return configuration;
        }
        ParameterMeta dataSet = this.findDataset(action).orElseThrow(() -> new IllegalArgumentException("Dataset not found for " + action.getAction()));
        String dataSetPath = dataSet.getPath();
        return configuration.entrySet().stream().filter(e -> this.isChildParameter((String)e.getKey(), dataSetPath)).collect(Collectors.toMap(e -> prefix + ((String)e.getKey()).substring(dataSetPath.length()), Map.Entry::getValue));
    }

    private boolean isChildParameter(String path, String parentPath) {
        return path.startsWith(parentPath) && path.substring(parentPath.length()).startsWith(".");
    }

    private Optional<ParameterMeta> findDataset(ServiceMeta.ActionMeta action) {
        ComponentFamilyMeta familyMeta = this.findFamily();
        ComponentFamilyMeta.BaseMeta<?> componentMeta = this.findComponent(familyMeta);
        Collection metas = this.toStream((Collection)componentMeta.getParameterMetas().get()).collect(Collectors.toList());
        return Optional.ofNullable(metas.stream().filter(p -> "dataset".equals(p.getMetadata().get("tcomp::configurationtype::type")) && action.getAction().equals(p.getMetadata().get("tcomp::configurationtype::name"))).findFirst().orElseGet(() -> {
            Iterator iterator = metas.stream().filter(p -> "dataset".equals(p.getMetadata().get("tcomp::configurationtype::type"))).iterator();
            if (iterator.hasNext()) {
                ParameterMeta value = (ParameterMeta)iterator.next();
                if (!iterator.hasNext()) {
                    return value;
                }
                log.warn("Multiple potential datasets for {}:{}, ignoring parameters", (Object)action.getType(), (Object)action.getAction());
            }
            return null;
        }));
    }

    private ComponentFamilyMeta.BaseMeta<?> findComponent(ComponentFamilyMeta familyMeta) {
        return Stream.concat(familyMeta.getPartitionMappers().entrySet().stream(), familyMeta.getProcessors().entrySet().stream()).filter(e -> ((String)e.getKey()).equals(this.componentName)).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalStateException("No component " + this.componentName));
    }

    private ComponentFamilyMeta findFamily() {
        return (ComponentFamilyMeta)((ContainerComponentRegistry)((Container)this.componentManager.findPlugin(this.plugin).orElseThrow(() -> new IllegalArgumentException("No component family " + this.plugin))).get(ContainerComponentRegistry.class)).getComponents().get(this.family);
    }

    private Stream<ParameterMeta> toStream(Collection<ParameterMeta> parameterMetas) {
        return Stream.concat(parameterMetas.stream(), parameterMetas.stream().map(ParameterMeta::getNestedParameters).filter(Objects::nonNull).flatMap(this::toStream));
    }

    private Optional<String> findFirstComponentDataSetName() {
        ComponentFamilyMeta familyMeta = this.findFamily();
        ComponentFamilyMeta.BaseMeta<?> componentMeta = this.findComponent(familyMeta);
        return this.toStream((Collection)componentMeta.getParameterMetas().get()).filter(p -> "dataset".equals(p.getMetadata().get("tcomp::configurationtype::type"))).findFirst().map(p -> (String)p.getMetadata().get("tcomp::configurationtype::name"));
    }

    public boolean guessSchemaThroughAction() {
        Object schemaResult;
        ServiceMeta.ActionMeta actionRef;
        Collection services = ((ContainerComponentRegistry)((Container)this.componentManager.findPlugin(this.plugin).orElseThrow(() -> new IllegalArgumentException("No component " + this.plugin))).get(ContainerComponentRegistry.class)).getServices();
        if (this.action == null || this.action.isEmpty()) {
            actionRef = this.findFirstComponentDataSetName().flatMap(datasetName -> services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getType().equals("schema")).filter(a -> a.getAction().equals(datasetName)).findFirst()).orElse(null);
            if (actionRef == null) {
                return false;
            }
        } else {
            actionRef = services.stream().flatMap(s -> s.getActions().stream()).filter(a -> a.getFamily().equals(this.family) && a.getAction().equals(this.action) && a.getType().equals("schema")).findFirst().orElseThrow(() -> new IllegalArgumentException("No action " + this.family + "#" + "schema" + "#" + this.action));
        }
        if ((schemaResult = actionRef.getInvoker().apply(this.buildActionConfig(actionRef, this.configuration))) instanceof Schema) {
            return this.fromSchema((Schema)Schema.class.cast(schemaResult));
        }
        log.error("Result of built-in guess schema action is not an instance of Talend Component Kit Schema");
        return false;
    }

    private boolean fromSchema(Schema schema) {
        List entries = schema.getEntries();
        if (entries == null || entries.isEmpty()) {
            log.info("No column found by guess schema action");
            return false;
        }
        for (Schema.Entry entry : entries) {
            String typeName;
            String name = entry.getName();
            Schema.Type entryType = entry.getType();
            String dbName = entry.getOriginalFieldName();
            String pattern = null;
            String length = null;
            String precision = null;
            boolean isDateTime = false;
            if (entryType == null) {
                entryType = Schema.Type.STRING;
            }
            switch (entryType) {
                case BOOLEAN: {
                    typeName = this.javaTypesManager.BOOLEAN.getId();
                    break;
                }
                case DOUBLE: {
                    typeName = this.javaTypesManager.DOUBLE.getId();
                    length = entry.getProp("talend.studio.length");
                    precision = entry.getProp("talend.studio.precision");
                    break;
                }
                case INT: {
                    typeName = this.javaTypesManager.INTEGER.getId();
                    break;
                }
                case LONG: {
                    typeName = this.javaTypesManager.LONG.getId();
                    break;
                }
                case FLOAT: {
                    typeName = this.javaTypesManager.FLOAT.getId();
                    length = entry.getProp("talend.studio.length");
                    precision = entry.getProp("talend.studio.precision");
                    break;
                }
                case BYTES: {
                    typeName = this.javaTypesManager.BYTE_ARRAY.getId();
                    break;
                }
                case DATETIME: {
                    typeName = this.javaTypesManager.DATE.getId();
                    isDateTime = true;
                    pattern = entry.getProp("talend.studio.pattern");
                    break;
                }
                case RECORD: {
                    typeName = this.javaTypesManager.OBJECT.getId();
                    break;
                }
                case ARRAY: {
                    typeName = this.javaTypesManager.LIST.getId();
                    break;
                }
                default: {
                    typeName = this.javaTypesManager.STRING.getId();
                }
            }
            Column column = new Column();
            column.setLabel(name);
            column.setOriginalDbColumnName(dbName);
            column.setTalendType(typeName);
            column.setNullable(entry.isNullable());
            column.setComment(entry.getComment());
            if (length != null && precision != null) {
                try {
                    column.setLength(Integer.valueOf(length));
                    column.setPrecision(Integer.valueOf(precision));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (isDateTime) {
                if (pattern != null) {
                    column.setPattern(STRING_ESCAPE + pattern + STRING_ESCAPE);
                } else {
                    column.setPattern("\"dd-MM-yyyy\"");
                }
            }
            if (entry.getDefaultValue() != null) {
                try {
                    column.setDefault(entry.getDefaultValue().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.columns.put(name, column);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean guessInputComponentSchemaThroughResult() throws Exception {
        Mapper mapper = (Mapper)this.componentManager.findMapper(this.family, this.componentName, 1, this.configuration).orElseThrow(() -> new IllegalArgumentException("Can't find " + this.family + "#" + this.componentName));
        if (JobStateAware.class.isInstance(mapper)) {
            ((JobStateAware)JobStateAware.class.cast(mapper)).setState(new JobStateAware.State());
        }
        Input input = null;
        try {
            mapper.start();
            ChainedMapper chainedMapper = new ChainedMapper(mapper, mapper.split(mapper.assess()).iterator());
            chainedMapper.start();
            input = chainedMapper.create();
            input.start();
            Object rowObject = input.next();
            if (rowObject == null) {
                boolean bl = false;
                return bl;
            }
            if (rowObject instanceof Record) {
                boolean bl = this.fromSchema(((Record)Record.class.cast(rowObject)).getSchema());
                return bl;
            }
            if (rowObject instanceof Map) {
                boolean bl = this.guessInputSchemaThroughResults(input, (Map)rowObject);
                return bl;
            }
            if (rowObject instanceof Collection) {
                throw new Exception("Can't guess schema from a Collection");
            }
            boolean bl = this.guessSchemaThroughResultClass(rowObject.getClass());
            return bl;
        }
        finally {
            if (input != null) {
                try {
                    input.stop();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                mapper.stop();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean guessSchemaThroughResult(Object rowObject) throws Exception {
        if (rowObject instanceof Map) {
            return this.guessSchemaThroughResult((Map)rowObject);
        }
        if (rowObject instanceof Collection) {
            throw new Exception("Can't guess schema from a Collection");
        }
        return this.guessSchemaThroughResultClass(rowObject.getClass());
    }

    private boolean guessSchemaThroughResultClass(Class<?> rowClass) {
        int originalSize = this.columns.size();
        for (Field field : rowClass.getDeclaredFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers)) continue;
            String name = field.getName();
            Column column = new Column();
            column.setLabel(name);
            column.setOriginalDbColumnName(name);
            column.setTalendType(this.getTalendType(field.getType()));
            column.setNullable(!field.getType().isPrimitive());
            this.columns.put(name, column);
        }
        return originalSize != this.columns.size();
    }

    private boolean guessInputSchemaThroughResults(Input input, Map<String, ?> rowObject) {
        this.keysNoTypeYet.clear();
        int originalSize = this.columns.size();
        Map row = rowObject;
        while (!this.guessSchemaThroughResult(row) && (row = (Map)input.next()) != null) {
        }
        for (String key : this.keysNoTypeYet) {
            Column column = new Column();
            column.setLabel(key);
            column.setOriginalDbColumnName(key);
            column.setTalendType(this.getTalendType(Object.class));
            column.setNullable(true);
            this.columns.put(key, column);
        }
        return originalSize != this.columns.size();
    }

    private boolean guessSchemaThroughResult(Map<String, ?> rowObject) {
        if (rowObject == null) {
            return false;
        }
        if (this.keysNoTypeYet.isEmpty() && this.lineCount < 0) {
            this.keysNoTypeYet.addAll(rowObject.keySet());
            this.lineCount = 0;
        }
        if (this.lineLimit <= this.lineCount) {
            for (String key : this.keysNoTypeYet) {
                Column column = new Column();
                column.setLabel(key);
                column.setOriginalDbColumnName(key);
                column.setTalendType(this.getTalendType(Object.class));
                column.setNullable(true);
                this.columns.put(key, column);
            }
            this.keysNoTypeYet.clear();
            return true;
        }
        ++this.lineCount;
        Iterator<String> iter = this.keysNoTypeYet.iterator();
        while (iter.hasNext()) {
            String type;
            String key = iter.next();
            Object result = rowObject.get(key);
            if (result == null || (type = Record.class.isInstance(rowObject) ? this.getTalendType(Object.class) : (JsonObject.class.isInstance(rowObject) ? this.getTalendType((JsonValue)result) : this.getTalendType(result.getClass()))) == null || type.trim().isEmpty()) continue;
            Column column = new Column();
            column.setLabel(key);
            column.setOriginalDbColumnName(key);
            column.setTalendType(type);
            column.setNullable(true);
            this.columns.put(key, column);
            iter.remove();
        }
        return this.keysNoTypeYet.isEmpty();
    }

    public synchronized void close() {
        if (!this.columns.isEmpty()) {
            try (Jsonb jsonb = JsonbBuilder.create();){
                jsonb.toJson(this.columns.values(), (OutputStream)this.out);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.out.flush();
            this.columns = new LinkedHashMap<String, Column>();
        }
    }

    protected String getTalendType(JsonValue value) {
        switch (value.getValueType()) {
            case TRUE: 
            case FALSE: {
                return this.javaTypesManager.BOOLEAN.getId();
            }
            case NUMBER: {
                Number number = ((JsonNumber)JsonNumber.class.cast(value)).numberValue();
                if (Long.class.isInstance(number)) {
                    return this.javaTypesManager.LONG.getId();
                }
                if (BigDecimal.class.isInstance(number)) {
                    return this.javaTypesManager.BIGDECIMAL.getId();
                }
                return this.javaTypesManager.DOUBLE.getId();
            }
            case STRING: {
                return this.javaTypesManager.STRING.getId();
            }
            case NULL: {
                return EMPTY;
            }
        }
        return this.javaTypesManager.OBJECT.getId();
    }

    private String getTalendType(Class type) {
        if (type == null) {
            return this.javaTypesManager.OBJECT.getId();
        }
        JavaType javaType = this.class2JavaTypeMap.get(type);
        if (javaType != null) {
            return javaType.getId();
        }
        return this.javaTypesManager.OBJECT.getId();
    }
}

