/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.design.extension.flows;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Input;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.design.extension.flows.FlowsFactory;

class ProcessorFlowsFactory
implements FlowsFactory {
    private final Class<?> type;

    @Override
    public Collection<String> getInputFlows() {
        return this.getListener().map(m -> Stream.of(m.getParameters())).orElseGet(() -> this.getAfterGroup().map(it -> Stream.of(it.getParameters())).orElseGet(Stream::empty)).filter(this::isInput).map(this::mapInputName).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getOutputFlows() {
        return Stream.concat(this.getListener().map(listener -> Stream.concat(this.getReturnedBranches((Method)listener), this.getOutputParameters((Method)listener))).orElseGet(Stream::empty), this.getAfterGroup().map(this::getOutputParameters).orElseGet(Stream::empty)).distinct().collect(Collectors.toList());
    }

    private Optional<Method> getAfterGroup() {
        return Stream.of(this.type.getMethods()).filter(m -> m.isAnnotationPresent(AfterGroup.class)).filter(it -> it.getParameterCount() > 0).findFirst();
    }

    private Stream<String> getOutputParameters(Method listener) {
        return Stream.of(listener.getParameters()).filter(p -> p.isAnnotationPresent(Output.class)).map(p -> p.getAnnotation(Output.class).value());
    }

    private Stream<String> getReturnedBranches(Method listener) {
        return listener.getReturnType().equals(Void.TYPE) ? Stream.empty() : Stream.of("__default__");
    }

    private Optional<Method> getListener() {
        return Stream.of(this.type.getMethods()).filter(m -> m.isAnnotationPresent(ElementListener.class)).findFirst();
    }

    private boolean isInput(Parameter p) {
        return p.isAnnotationPresent(Input.class) || !p.isAnnotationPresent(Output.class);
    }

    private String mapInputName(Parameter p) {
        return Optional.ofNullable(p.getAnnotation(Input.class)).map(Input::value).orElse("__default__");
    }

    @Generated
    public ProcessorFlowsFactory(Class<?> type) {
        this.type = type;
    }
}

