/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.design.extension;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.design.extension.DesignModel;
import org.talend.sdk.component.design.extension.RepositoryModel;
import org.talend.sdk.component.design.extension.flows.FlowsFactory;
import org.talend.sdk.component.design.extension.repository.RepositoryModelBuilder;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.extension.ComponentContexts;
import org.talend.sdk.component.runtime.manager.reflect.MigrationHandlerFactory;
import org.talend.sdk.component.runtime.manager.spi.ContainerListenerExtension;
import org.talend.sdk.component.spi.component.ComponentExtension;

public class DesignContainerListener
implements ContainerListenerExtension {
    private final RepositoryModelBuilder repositoryModelBuilder = new RepositoryModelBuilder();
    private MigrationHandlerFactory migrationHandlerFactory;

    public void setComponentManager(ComponentManager manager) {
        this.migrationHandlerFactory = manager.getMigrationHandlerFactory();
    }

    public void onCreate(Container container) {
        ContainerComponentRegistry componentRegistry = (ContainerComponentRegistry)container.get(ContainerComponentRegistry.class);
        if (componentRegistry == null) {
            throw new IllegalArgumentException("container doesn't contain ContainerComponentRegistry");
        }
        Collection<ComponentFamilyMeta> componentFamilyMetas = componentRegistry.getComponents().values();
        componentFamilyMetas.stream().flatMap(family -> Stream.of(family.getPartitionMappers().values().stream(), family.getProcessors().values().stream(), family.getDriverRunners().values().stream()).flatMap(t -> t)).forEach(meta -> {
            ComponentExtension.ComponentContext context = (ComponentExtension.ComponentContext)((ComponentContexts)container.get(ComponentContexts.class)).getContexts().get(meta.getType());
            ComponentExtension owningExtension = context.owningExtension();
            meta.set(DesignModel.class, (Object)Optional.ofNullable(owningExtension).map(e -> (FlowsFactory)e.unwrap(FlowsFactory.class, new Object[]{meta})).map(e -> new DesignModel(meta.getId(), e.getInputFlows(), e.getOutputFlows())).orElseGet(() -> {
                FlowsFactory factory = FlowsFactory.get(meta);
                return new DesignModel(meta.getId(), factory.getInputFlows(), factory.getOutputFlows());
            }));
        });
        container.set(RepositoryModel.class, (Object)this.repositoryModelBuilder.create((ComponentManager.AllServices)container.get(ComponentManager.AllServices.class), componentFamilyMetas, this.migrationHandlerFactory));
    }

    public void onClose(Container container) {
    }
}

