/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbTransient;
import lombok.Generated;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.record.SchemaProperty;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaCache;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaConverter;
import org.talend.sdk.component.runtime.beam.spi.record.Decimal;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public class AvroSchema
implements org.talend.sdk.component.api.record.Schema,
AvroPropertyMapper,
Unwrappable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    private static final AvroSchemaCache SCHEMA_CACHE = AvroSchema.initCache();
    @JsonbTransient
    private final Schema delegate;
    private AvroSchema elementSchema;
    private List<Schema.Entry> entries;
    @JsonbTransient
    private Map<String, Schema.Entry> entryMap;
    @JsonbTransient
    private List<Schema.Entry> metadataEntries;
    private Schema.Type type;
    private Schema actualDelegate;

    private static AvroSchemaCache initCache() {
        AvroSchemaConverter converter = new AvroSchemaConverter();
        return new AvroSchemaCache(converter::convert);
    }

    static AvroSchema toAvroSchema(org.talend.sdk.component.api.record.Schema schema) {
        if (schema.getType() == Schema.Type.RECORD && schema.getAllEntries().noneMatch(it -> true)) {
            return new AvroSchema(AvroSchemas.getEmptySchema());
        }
        return SCHEMA_CACHE.find(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Schema getActualDelegate() {
        if (this.actualDelegate != null) {
            return this.actualDelegate;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.actualDelegate != null) {
                return this.actualDelegate;
            }
            this.actualDelegate = AvroSchemas.unwrapUnion(this.delegate);
        }
        return this.actualDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schema.Type getType() {
        if (this.type != null) {
            return this.type;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.type != null) {
                return this.type;
            }
            this.type = this.mapType(this.getActualDelegate());
        }
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.talend.sdk.component.api.record.Schema getElementSchema() {
        if (this.elementSchema != null) {
            return this.elementSchema;
        }
        if (this.getActualDelegate().getType() == Schema.Type.ARRAY) {
            AvroSchema avroSchema = this;
            synchronized (avroSchema) {
                if (this.elementSchema != null) {
                    return this.elementSchema;
                }
                this.elementSchema = new AvroSchema(this.getActualDelegate().getElementType());
            }
        }
        return this.elementSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schema.Entry> getEntries() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyList();
        }
        if (this.entries != null) {
            return this.entries;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.entries != null) {
                return this.entries;
            }
            this.entries = this.getNonNullFields().filter(f -> !AvroSchema.isMetadata(f)).map(this::fromAvro).collect(Collectors.toList());
        }
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Schema.Entry> getMetadata() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyList();
        }
        if (this.metadataEntries != null) {
            return this.metadataEntries;
        }
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.metadataEntries == null) {
                this.metadataEntries = this.getNonNullFields().filter(AvroSchema::isMetadata).map(this::fromAvro).collect(Collectors.toList());
            }
        }
        return this.metadataEntries;
    }

    @JsonbTransient
    public Stream<Schema.Entry> getAllEntries() {
        return Stream.concat(this.getEntries().stream(), this.getMetadata().stream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonbTransient
    public Map<String, Schema.Entry> getEntryMap() {
        AvroSchema avroSchema = this;
        synchronized (avroSchema) {
            if (this.entryMap == null || this.entryMap.isEmpty()) {
                if (this.entryMap == null) {
                    this.entryMap = new HashMap<String, Schema.Entry>();
                }
                this.getAllEntries().forEach(e -> this.entryMap.put(e.getName(), (Schema.Entry)e));
            }
        }
        return this.entryMap;
    }

    @JsonbTransient
    public Schema.EntriesOrder naturalOrder() {
        return Schema.EntriesOrder.of((String)this.getActualDelegate().getProp("talend.fields.order"));
    }

    private Stream<Schema.Field> getNonNullFields() {
        return this.getActualDelegate().getFields().stream().filter(it -> it.schema().getType() != Schema.Type.NULL);
    }

    private static boolean isMetadata(Schema.Field f) {
        return f.aliases() != null && f.aliases().contains("talend.field.__METADATA__");
    }

    private Schema.Entry fromAvro(Schema.Field field) {
        Schema.Type fieldType = this.mapType(field.schema());
        Optional<SchemaProperty.LogicalType> logicalType = this.mapLogicalType(field.schema());
        AvroSchema fieldSchema = new AvroSchema(fieldType == Schema.Type.ARRAY ? AvroSchemas.unwrapUnion(field.schema()).getElementType() : field.schema());
        return AvroSchema.buildFromAvro(field, fieldType, logicalType, fieldSchema);
    }

    private static Schema.Entry buildFromAvro(Schema.Field field, Schema.Type type, Optional<SchemaProperty.LogicalType> logicalType, AvroSchema elementSchema) {
        Schema.Entry.Builder builder = new SchemaImpl.EntryImpl.BuilderImpl().withName(field.name()).withRawName(field.getProp("talend.component.label")).withType(type).withNullable(field.schema().getType() == Schema.Type.UNION).withErrorCapable(Boolean.parseBoolean(field.getProp("talend.component.record.entry.errorCapable"))).withMetadata(AvroSchema.isMetadata(field)).withDefaultValue(field.defaultVal()).withElementSchema((org.talend.sdk.component.api.record.Schema)elementSchema).withComment(field.doc()).withProps(field.getObjectProps().entrySet().stream().filter(p -> !((String)p.getKey()).equals("talend.component.record.entry.errorCapable")).collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()))));
        logicalType.ifPresent(arg_0 -> ((Schema.Entry.Builder)builder).withLogicalType(arg_0));
        return builder.build();
    }

    public Map<String, String> getProps() {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return Collections.emptyMap();
        }
        return this.getActualDelegate().getObjectProps().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue())));
    }

    public String getProp(String property) {
        if (this.getActualDelegate().getType() != Schema.Type.RECORD) {
            return null;
        }
        return this.getActualDelegate().getProp(property);
    }

    public Schema.Builder toBuilder() {
        Schema.Builder builder = new AvroSchemaBuilder().withType(Schema.Type.RECORD).withElementSchema((org.talend.sdk.component.api.record.Schema)this.elementSchema).withProps(this.getProps().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.getEntriesOrdered().forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
        return builder;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this.delegate)) {
            return type.cast(this.delegate);
        }
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private Optional<SchemaProperty.LogicalType> mapLogicalType(Schema schema) {
        LogicalType avroLogicalType = schema.getLogicalType();
        if (LogicalTypes.date().equals(avroLogicalType)) {
            return Optional.of(SchemaProperty.LogicalType.DATE);
        }
        if (LogicalTypes.timeMillis().equals(avroLogicalType)) {
            return Optional.of(SchemaProperty.LogicalType.TIME);
        }
        if (LogicalTypes.timestampMillis().equals(avroLogicalType)) {
            return Optional.of(SchemaProperty.LogicalType.TIMESTAMP);
        }
        return Optional.empty();
    }

    private Schema.Type mapType(Schema schema) {
        return this.doMapType(AvroSchemas.unwrapUnion(schema));
    }

    private Schema.Type doMapType(Schema schema) {
        switch (schema.getType()) {
            case INT: {
                if (LogicalTypes.date().equals(LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema)) || LogicalTypes.timeMillis().equals(LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema))) {
                    return Schema.Type.DATETIME;
                }
                return Schema.Type.INT;
            }
            case LONG: {
                if (Boolean.parseBoolean(this.readProp(schema, Schema.Type.DATETIME.name())) || LogicalTypes.timestampMillis().equals(LogicalTypes.fromSchemaIgnoreInvalid((Schema)schema))) {
                    return Schema.Type.DATETIME;
                }
                return Schema.Type.LONG;
            }
            case STRING: {
                if (Boolean.parseBoolean(this.readProp(schema, Schema.Type.DECIMAL.name())) || ((Object)((Object)Decimal.logicalType())).equals(schema.getLogicalType())) {
                    return Schema.Type.DECIMAL;
                }
                return Schema.Type.STRING;
            }
            case ENUM: {
                return Schema.Type.STRING;
            }
            case FIXED: {
                String logicalType;
                String string = logicalType = schema.getLogicalType() != null ? schema.getLogicalType().getName() : "";
                if (Boolean.parseBoolean(this.readProp(schema, Schema.Type.DECIMAL.name())) || Decimal.logicalType().getName().equals(logicalType)) {
                    return Schema.Type.DECIMAL;
                }
                if (LogicalTypes.uuid().getName().equals(logicalType)) {
                    return Schema.Type.STRING;
                }
                return Schema.Type.BYTES;
            }
            case MAP: 
            case UNION: 
            case NULL: {
                log.warn("[doMapType] unmanaged avro type {}. Storing as Object.", (Object)schema.getType());
                return Schema.Type.RECORD;
            }
        }
        return Schema.Type.valueOf((String)schema.getType().name());
    }

    @Generated
    public AvroSchema(Schema delegate) {
        this.delegate = delegate;
    }

    @Generated
    public Schema getDelegate() {
        return this.delegate;
    }

    @Generated
    public List<Schema.Entry> getMetadataEntries() {
        return this.metadataEntries;
    }

    @Generated
    public void setElementSchema(AvroSchema elementSchema) {
        this.elementSchema = elementSchema;
    }

    @Generated
    public void setEntries(List<Schema.Entry> entries) {
        this.entries = entries;
    }

    @Generated
    public void setEntryMap(Map<String, Schema.Entry> entryMap) {
        this.entryMap = entryMap;
    }

    @Generated
    public void setMetadataEntries(List<Schema.Entry> metadataEntries) {
        this.metadataEntries = metadataEntries;
    }

    @Generated
    public void setType(Schema.Type type) {
        this.type = type;
    }

    @Generated
    public void setActualDelegate(Schema actualDelegate) {
        this.actualDelegate = actualDelegate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AvroSchema)) {
            return false;
        }
        AvroSchema other = (AvroSchema)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema this$delegate = this.getDelegate();
        Schema other$delegate = other.getDelegate();
        return !(this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AvroSchema;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AvroSchema(delegate=" + this.getDelegate() + ")";
    }
}

