/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform;

import java.util.Collections;
import lombok.Generated;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.beam.spi.record.RecordCollectors;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class CoGroupByKeyResultMappingTransform<K>
extends PTransform<PCollection<KV<K, CoGbkResult>>, PCollection<Record>> {
    private String plugin;
    private boolean propagateKey;

    public PCollection<Record> expand(PCollection<KV<K, CoGbkResult>> input) {
        return (PCollection)input.apply((PTransform)ParDo.of(new CoGBKMappingFn(this.plugin, this.propagateKey, null)));
    }

    protected Coder<?> getDefaultOutputCoder() {
        return SchemaRegistryCoder.of();
    }

    @Generated
    public CoGroupByKeyResultMappingTransform(String plugin, boolean propagateKey) {
        this.plugin = plugin;
        this.propagateKey = propagateKey;
    }

    @Generated
    protected CoGroupByKeyResultMappingTransform() {
    }

    public static class CoGBKMappingFn<K>
    extends DoFn<KV<K, CoGbkResult>, Record> {
        private String plugin;
        private boolean propagateKey;
        private volatile RecordBuilderFactory builderFactory;

        @DoFn.ProcessElement
        public void onElement(DoFn.ProcessContext context) {
            context.output((Object)this.createMap(context));
        }

        private Record createMap(DoFn.ProcessContext context) {
            KV element = (KV)context.element();
            CoGbkResult result = (CoGbkResult)element.getValue();
            RecordBuilderFactory builderFactory = this.builderFactory();
            Record.Builder builder = result.getSchema().getTupleTagList().getAll().stream().map(key -> new Pair<String, Record>(key.getId(), (Record)Record.class.cast(result.getOnly(key, null)))).filter(p -> p.getSecond() != null).collect(() -> ((RecordBuilderFactory)builderFactory).newRecordBuilder(), (b, p) -> {
                Record record = (Record)p.getSecond();
                Schema.Entry entry = builderFactory.newEntryBuilder().withName((String)p.getFirst()).withType(Schema.Type.ARRAY).withElementSchema(record.getSchema()).build();
                b.withArray(entry, Collections.singletonList(record));
            }, RecordCollectors::merge);
            if (this.propagateKey) {
                Record internalRecord = builderFactory.newRecordBuilder().withString("key", String.valueOf(element.getKey())).build();
                builder.withRecord(builderFactory.newEntryBuilder().withName("__talend_internal").withType(Schema.Type.RECORD).withElementSchema(internalRecord.getSchema()).build(), internalRecord);
            }
            return builder.build();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RecordBuilderFactory builderFactory() {
            if (this.builderFactory == null) {
                CoGBKMappingFn coGBKMappingFn = this;
                synchronized (coGBKMappingFn) {
                    if (this.builderFactory == null) {
                        LightContainer container = ContainerFinder.Instance.get().find(this.plugin);
                        this.builderFactory = (RecordBuilderFactory)container.findService(RecordBuilderFactory.class);
                    }
                }
            }
            return this.builderFactory;
        }

        @Generated
        private CoGBKMappingFn(String plugin, boolean propagateKey, RecordBuilderFactory builderFactory) {
            this.plugin = plugin;
            this.propagateKey = propagateKey;
            this.builderFactory = builderFactory;
        }

        @Generated
        protected CoGBKMappingFn() {
        }
    }

    private static class Pair<A, B> {
        private A first;
        private B second;

        @Generated
        public A getFirst() {
            return this.first;
        }

        @Generated
        public B getSecond() {
            return this.second;
        }

        @Generated
        public void setFirst(A first) {
            this.first = first;
        }

        @Generated
        public void setSecond(B second) {
            this.second = second;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            A this$first = this.getFirst();
            A other$first = other.getFirst();
            if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
                return false;
            }
            B this$second = this.getSecond();
            B other$second = other.getSecond();
            return !(this$second == null ? other$second != null : !this$second.equals(other$second));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            A $first = this.getFirst();
            result = result * 59 + ($first == null ? 43 : $first.hashCode());
            B $second = this.getSecond();
            result = result * 59 + ($second == null ? 43 : $second.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CoGroupByKeyResultMappingTransform.Pair(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
        }

        @Generated
        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        @Generated
        public Pair() {
        }
    }
}

