/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder.registry;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.beam.sdk.coders.AvroCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AvroCoderCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AvroCoderCache.class);
    private static final Map<Schema, AvroCoder<IndexedRecord>> CACHED_CODERS = new LinkedHashMap<Schema, AvroCoder<IndexedRecord>>(){
        private final int MAX_SIZE = Integer.getInteger("component.runtime.beam.avrocoder.cache.size", 1024);

        @Override
        protected boolean removeEldestEntry(Map.Entry<Schema, AvroCoder<IndexedRecord>> eldest) {
            return this.size() > this.MAX_SIZE;
        }

        @Override
        public synchronized AvroCoder<IndexedRecord> get(Object key) {
            AvroCoder coder = (AvroCoder)super.get(key);
            if (coder == null) {
                Schema schema = (Schema)Schema.class.cast(key);
                coder = AvroCoder.of(IndexedRecord.class, (Schema)schema);
                this.put(schema, coder);
            }
            return coder;
        }
    };

    static AvroCoder<IndexedRecord> getCoder(Schema avro) {
        return CACHED_CODERS.get(avro);
    }

    @Generated
    private AvroCoderCache() {
    }
}

