/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform;

import java.util.function.Function;
import lombok.Generated;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.beam.transform.RecordParDoTransformCoderProvider;
import org.talend.sdk.component.runtime.manager.chain.GroupKeyProvider;

public class AutoKVWrapper
extends DoFn<Record, KV<String, Record>> {
    private Function<GroupKeyProvider.GroupContext, String> idGenerator;
    private String component;
    private String branch;

    protected AutoKVWrapper() {
    }

    @DoFn.ProcessElement
    public void onElement(DoFn.ProcessContext context) {
        Record element = (Record)context.element();
        String key = this.idGenerator.apply(new GroupContextImpl(element, this.component, this.branch));
        context.output((Object)KV.of((Object)key, (Object)element));
    }

    public static PTransform<PCollection<Record>, PCollection<KV<String, Record>>> of(String plugin, Function<GroupKeyProvider.GroupContext, String> idGenerator, String component, String branch) {
        return new RecordParDoTransformCoderProvider<KV<String, Record>>((Coder<KV<String, Record>>)KvCoder.of((Coder)StringUtf8Coder.of(), (Coder)SchemaRegistryCoder.of()), new AutoKVWrapper(idGenerator, component, branch));
    }

    @Generated
    public AutoKVWrapper(Function<GroupKeyProvider.GroupContext, String> idGenerator, String component, String branch) {
        this.idGenerator = idGenerator;
        this.component = component;
        this.branch = branch;
    }

    private static class GroupContextImpl
    implements GroupKeyProvider.GroupContext {
        private final Record data;
        private final String componentId;
        private final String branchName;

        @Generated
        public GroupContextImpl(Record data, String componentId, String branchName) {
            this.data = data;
            this.componentId = componentId;
            this.branchName = branchName;
        }

        @Generated
        public Record getData() {
            return this.data;
        }

        @Generated
        public String getComponentId() {
            return this.componentId;
        }

        @Generated
        public String getBranchName() {
            return this.branchName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupContextImpl)) {
                return false;
            }
            GroupContextImpl other = (GroupContextImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Record this$data = this.getData();
            Record other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$componentId = this.getComponentId();
            String other$componentId = other.getComponentId();
            if (this$componentId == null ? other$componentId != null : !this$componentId.equals(other$componentId)) {
                return false;
            }
            String this$branchName = this.getBranchName();
            String other$branchName = other.getBranchName();
            return !(this$branchName == null ? other$branchName != null : !this$branchName.equals(other$branchName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupContextImpl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Record $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $componentId = this.getComponentId();
            result = result * 59 + ($componentId == null ? 43 : $componentId.hashCode());
            String $branchName = this.getBranchName();
            result = result * 59 + ($branchName == null ? 43 : $branchName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AutoKVWrapper.GroupContextImpl(data=" + this.getData() + ", componentId=" + this.getComponentId() + ", branchName=" + this.getBranchName() + ")";
        }
    }
}

