/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.io;

import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;

public class NoCloseInputStream
extends InputStream {
    private final InputStream in;
    private long maxBytes;

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        if (this.maxBytes == 0L) {
            return -1;
        }
        --this.maxBytes;
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.maxBytes == 0L) {
            return -1;
        }
        int read = this.in.read(b, 0, this.maxBytesOrMaxValue());
        this.maxBytes -= (long)read;
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.maxBytes == 0L) {
            return -1;
        }
        int read = this.in.read(b, off, Math.min(this.maxBytesOrMaxValue(), len));
        this.maxBytes -= (long)read;
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.maxBytes == 0L) {
            return 0L;
        }
        long skip = this.in.skip(Math.min(this.maxBytes, n));
        this.maxBytes -= skip;
        return skip;
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.in.available(), this.maxBytesOrMaxValue());
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    private int maxBytesOrMaxValue() {
        return this.maxBytes > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.maxBytes;
    }

    @Generated
    public NoCloseInputStream(InputStream in, long maxBytes) {
        this.in = in;
        this.maxBytes = maxBytes;
    }
}

