/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.AvroTypeException;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.sdk.component.api.record.OrderedMap;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.record.SchemaCompanionUtil;
import org.talend.sdk.component.api.record.SchemaProperty;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.beam.spi.record.Decimal;
import org.talend.sdk.component.runtime.beam.spi.record.SchemaIdGenerator;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.Schemas;

public class AvroSchemaBuilder
implements Schema.Builder {
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final AvroSchema BYTES_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
    private static final AvroSchema INT_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.INT));
    private static final AvroSchema LONG_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    private static final AvroSchema DATETIME_SCHEMA = new AvroSchema(new AvroPropertyMapper(){}.setProp(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.Type.DATETIME.name(), "true"));
    private static final AvroSchema DATE_SCHEMA = new AvroSchema(new AvroPropertyMapper(){}.setProp(LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), Schema.Type.DATETIME.name(), "true"));
    private static final AvroSchema TIME_SCHEMA = new AvroSchema(new AvroPropertyMapper(){}.setProp(LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), Schema.Type.DATETIME.name(), "true"));
    private static final AvroSchema STRING_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.STRING));
    private static final AvroSchema DOUBLE_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.DOUBLE));
    private static final AvroSchema FLOAT_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.FLOAT));
    private static final AvroSchema BOOLEAN_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
    private static final AvroSchema BYTES_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.BYTES), NULL_SCHEMA)));
    private static final AvroSchema INT_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), NULL_SCHEMA)));
    private static final AvroSchema LONG_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.LONG), NULL_SCHEMA)));
    private static final AvroSchema DATETIME_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(new AvroPropertyMapper(){}.setProp(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.Type.DATETIME.name(), "true"), NULL_SCHEMA)));
    private static final AvroSchema DATE_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(new AvroPropertyMapper(){}.setProp(LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), Schema.Type.DATETIME.name(), "true"), NULL_SCHEMA)));
    private static final AvroSchema TIME_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(new AvroPropertyMapper(){}.setProp(LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT)), Schema.Type.DATETIME.name(), "true"), NULL_SCHEMA)));
    private static final AvroSchema STRING_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), NULL_SCHEMA)));
    private static final AvroSchema DOUBLE_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.DOUBLE), NULL_SCHEMA)));
    private static final AvroSchema FLOAT_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.FLOAT), NULL_SCHEMA)));
    private static final AvroSchema BOOLEAN_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.BOOLEAN), NULL_SCHEMA)));
    private static final AvroSchema DECIMAL_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(new AvroPropertyMapper(){}.setProp(Decimal.logicalType().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)), Schema.Type.DECIMAL.name(), "true"), NULL_SCHEMA)));
    private static final AvroSchema DECIMAL_SCHEMA = new AvroSchema(new AvroPropertyMapper(){}.setProp(Decimal.logicalType().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING)), Schema.Type.DECIMAL.name(), "true"));
    private OrderedMap<Schema.Entry> fields;
    private Schema.Type type;
    private org.talend.sdk.component.api.record.Schema elementSchema;
    private final Map<String, String> props = new LinkedHashMap<String, String>(0);

    public Schema.Builder withType(Schema.Type type) {
        this.type = type;
        return this;
    }

    public Schema.Builder withEntry(Schema.Entry entry) {
        if (this.type != Schema.Type.RECORD) {
            throw new IllegalArgumentException("entry is only valid for RECORD type of schema");
        }
        if (this.fields == null) {
            this.fields = new OrderedMap(Schema.Entry::getName, Collections.singletonList(entry));
        }
        Schema.Entry realEntry = SchemaCompanionUtil.avoidCollision((Schema.Entry)entry, arg_0 -> this.fields.getValue(arg_0), (arg_0, arg_1) -> this.fields.replace(arg_0, arg_1));
        this.fields.addValue((Object)realEntry);
        return this;
    }

    private Schema.Field entryToAvroField(final Schema.Entry entry) {
        AvroSchema unwrappable;
        switch (entry.getType()) {
            case RECORD: {
                unwrappable = (Unwrappable)Unwrappable.class.cast(entry.getElementSchema());
                break;
            }
            case ARRAY: {
                unwrappable = new Unwrappable(){

                    public <T> T unwrap(Class<T> type) {
                        return type.cast(Schema.createArray((Schema)((Schema)((Unwrappable)Unwrappable.class.cast(entry.getElementSchema())).unwrap(Schema.class))));
                    }
                };
                break;
            }
            case BOOLEAN: {
                unwrappable = !entry.isNullable() ? BOOLEAN_SCHEMA : BOOLEAN_SCHEMA_NULLABLE;
                break;
            }
            case DOUBLE: {
                unwrappable = !entry.isNullable() ? DOUBLE_SCHEMA : DOUBLE_SCHEMA_NULLABLE;
                break;
            }
            case INT: {
                unwrappable = !entry.isNullable() ? INT_SCHEMA : INT_SCHEMA_NULLABLE;
                break;
            }
            case FLOAT: {
                unwrappable = !entry.isNullable() ? FLOAT_SCHEMA : FLOAT_SCHEMA_NULLABLE;
                break;
            }
            case BYTES: {
                unwrappable = !entry.isNullable() ? BYTES_SCHEMA : BYTES_SCHEMA_NULLABLE;
                break;
            }
            case LONG: {
                unwrappable = !entry.isNullable() ? LONG_SCHEMA : LONG_SCHEMA_NULLABLE;
                break;
            }
            case STRING: {
                unwrappable = !entry.isNullable() ? STRING_SCHEMA : STRING_SCHEMA_NULLABLE;
                break;
            }
            case DATETIME: {
                String logicalType = entry.getLogicalType();
                if (SchemaProperty.LogicalType.DATE.key().equals(logicalType)) {
                    unwrappable = !entry.isNullable() ? DATE_SCHEMA : DATE_SCHEMA_NULLABLE;
                    break;
                }
                if (SchemaProperty.LogicalType.TIME.key().equals(logicalType)) {
                    unwrappable = !entry.isNullable() ? TIME_SCHEMA : TIME_SCHEMA_NULLABLE;
                    break;
                }
                unwrappable = !entry.isNullable() ? DATETIME_SCHEMA : DATETIME_SCHEMA_NULLABLE;
                break;
            }
            case DECIMAL: {
                unwrappable = !entry.isNullable() ? DECIMAL_SCHEMA : DECIMAL_SCHEMA_NULLABLE;
                break;
            }
            default: {
                unwrappable = (Unwrappable)Unwrappable.class.cast(new AvroSchemaBuilder().withType(entry.getType()).build());
            }
        }
        Schema schema = (Schema)((Unwrappable)Unwrappable.class.cast(unwrappable)).unwrap(Schema.class);
        return AvroHelper.toField(schema, entry);
    }

    public Schema.Builder withEntryAfter(String after, Schema.Entry entry) {
        this.withEntry(entry);
        return this.moveAfter(after, entry.getName());
    }

    public Schema.Builder withEntryBefore(String before, Schema.Entry entry) {
        this.withEntry(entry);
        return this.moveBefore(before, entry.getName());
    }

    public Schema.Builder remove(String name) {
        Schema.Entry entry = (Schema.Entry)this.fields.getValue(name);
        return this.remove(entry);
    }

    public Schema.Builder remove(Schema.Entry entry) {
        if (entry != null) {
            this.fields.removeValue((Object)entry);
        }
        return this;
    }

    public Schema.Builder moveAfter(String after, String name) {
        Schema.Entry entryToMove = (Schema.Entry)this.fields.getValue(name);
        if (entryToMove == null) {
            throw new IllegalArgumentException(String.format("%s not in schema", name));
        }
        this.fields.moveAfter(after, (Object)entryToMove);
        return this;
    }

    public Schema.Builder moveBefore(String before, String name) {
        Schema.Entry entryToMove = (Schema.Entry)this.fields.getValue(name);
        if (entryToMove == null) {
            throw new IllegalArgumentException(String.format("%s not in schema", name));
        }
        this.fields.moveBefore(before, (Object)entryToMove);
        return this;
    }

    public Schema.Builder swap(String name, String with) {
        this.fields.swap(name, with);
        return this;
    }

    public Schema.Builder withElementSchema(org.talend.sdk.component.api.record.Schema schema) {
        if (this.type != Schema.Type.ARRAY && schema != null) {
            throw new IllegalArgumentException("elementSchema is only valid for ARRAY type of schema");
        }
        org.talend.sdk.component.api.record.Schema avroSchema = this.toAvroSchema(schema);
        AvroSchema avro = (AvroSchema)avroSchema;
        this.elementSchema = this.wrapNullable(avro);
        return this;
    }

    private AvroSchema wrapNullable(AvroSchema schema) {
        if (schema == null) {
            return null;
        }
        Schema delegate = schema.getDelegate();
        if (delegate.getType() != Schema.Type.UNION) {
            Schema nullableType = Schema.createUnion((Schema[])new Schema[]{delegate, Schema.create((Schema.Type)Schema.Type.NULL)});
            return new AvroSchema(nullableType);
        }
        return schema;
    }

    private org.talend.sdk.component.api.record.Schema toAvroSchema(org.talend.sdk.component.api.record.Schema schema) {
        if (schema == null || schema instanceof AvroSchema) {
            return schema;
        }
        Schema.Builder builder = new AvroSchemaBuilder().withType(schema.getType());
        org.talend.sdk.component.api.record.Schema elementSchema = schema.getElementSchema();
        if (elementSchema != null) {
            org.talend.sdk.component.api.record.Schema avroSchema = this.toAvroSchema(elementSchema);
            builder.withElementSchema(avroSchema);
        }
        builder.withProps(schema.getProps());
        schema.getEntries().stream().map(this::convertEntry).forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
        return builder.build();
    }

    private Schema.Entry convertEntry(Schema.Entry entry) {
        org.talend.sdk.component.api.record.Schema elementSchema = entry.getElementSchema();
        if (elementSchema == null || elementSchema instanceof AvroSchema) {
            return entry;
        }
        org.talend.sdk.component.api.record.Schema avroSchema = this.toAvroSchema(elementSchema);
        return entry.toBuilder().withElementSchema(avroSchema).build();
    }

    public Schema.Builder withProp(String key, String value) {
        this.props.put(key, value);
        return this;
    }

    public Schema.Builder withProps(Map<String, String> props) {
        if (props == null) {
            return this;
        }
        this.props.putAll(props);
        return this;
    }

    public org.talend.sdk.component.api.record.Schema build() {
        return this.build(null);
    }

    public org.talend.sdk.component.api.record.Schema build(Comparator<Schema.Entry> order) {
        switch (this.type) {
            case BYTES: {
                return BYTES_SCHEMA;
            }
            case INT: {
                return INT_SCHEMA;
            }
            case LONG: {
                return LONG_SCHEMA;
            }
            case STRING: {
                return STRING_SCHEMA;
            }
            case DOUBLE: {
                return DOUBLE_SCHEMA;
            }
            case FLOAT: {
                return FLOAT_SCHEMA;
            }
            case BOOLEAN: {
                return BOOLEAN_SCHEMA;
            }
            case DATETIME: {
                return DATETIME_SCHEMA;
            }
            case DECIMAL: {
                return DECIMAL_SCHEMA;
            }
            case RECORD: {
                if (this.fields == null) {
                    return new AvroSchema(AvroSchemas.getEmptySchema());
                }
                List<Schema.Field> avroFields = this.fields.streams().map(this::entryToAvroField).collect(Collectors.toList());
                Schema record = Schema.createRecord((String)SchemaIdGenerator.generateRecordName(avroFields), null, (String)"talend.component.schema", (boolean)false);
                record.setFields(avroFields);
                if (order != null) {
                    String entriesOrder = this.fields.streams().sorted(order).map(Schema.Entry::getName).collect(Collectors.joining(","));
                    record.addProp("talend.fields.order", entriesOrder);
                } else {
                    record.addProp("talend.fields.order", this.fields.streams().map(Schema.Entry::getName).collect(Collectors.joining(",")));
                }
                this.props.entrySet().stream().filter(e -> !"talend.fields.order".equals(e.getKey())).forEach(e -> record.addProp((String)e.getKey(), (String)e.getValue()));
                return new AvroSchema(record);
            }
            case ARRAY: {
                if (this.elementSchema == null) {
                    throw new IllegalStateException("No elementSchema set for this ARRAY schema");
                }
                Schema elementType = this.elementSchema == Schemas.EMPTY_RECORD ? AvroSchemas.getEmptySchema() : (Schema)((Unwrappable)Unwrappable.class.cast(this.elementSchema)).unwrap(Schema.class);
                return new AvroSchema(Schema.createArray((Schema)elementType));
            }
        }
        throw new IllegalArgumentException("Unsupported: " + this.type);
    }

    public static class AvroHelper {
        public static Schema.Field toField(Schema schema, Schema.Entry entry) {
            Schema.Field field = null;
            try {
                field = new Schema.Field(SchemaCompanionUtil.sanitizeName((String)entry.getName()), entry.isNullable() && schema.getType() != Schema.Type.UNION ? Schema.createUnion(Arrays.asList(schema, NULL_SCHEMA)) : schema, entry.getComment(), entry.getDefaultValue());
            }
            catch (AvroTypeException e) {
                field = new Schema.Field(SchemaCompanionUtil.sanitizeName((String)entry.getName()), entry.isNullable() && schema.getType() != Schema.Type.UNION ? Schema.createUnion(Arrays.asList(schema, NULL_SCHEMA)) : schema, entry.getComment());
            }
            if (entry.isMetadata()) {
                field.addAlias("talend.field.__METADATA__");
            }
            if (entry.getRawName() != null) {
                field.addProp("talend.component.label", entry.getRawName());
            }
            for (Map.Entry e : entry.getProps().entrySet()) {
                field.addProp((String)e.getKey(), (String)e.getValue());
            }
            if (entry.isErrorCapable()) {
                field.addProp("talend.component.record.entry.errorCapable", String.valueOf(entry.isErrorCapable()));
            }
            return field;
        }
    }
}

