/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import lombok.Generated;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.util.VarInt;
import org.talend.sdk.component.runtime.beam.io.CountingOutputStream;
import org.talend.sdk.component.runtime.beam.io.NoCloseInputStream;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class JsonpJsonObjectCoder
extends CustomCoder<JsonObject> {
    private JsonReaderFactory readerFactory;
    private JsonWriterFactory writerFactory;

    public void encode(JsonObject jsonObject, OutputStream outputStream) throws IOException {
        CountingOutputStream buffer = new CountingOutputStream();
        try (JsonWriter writer = this.writerFactory.createWriter((OutputStream)new GZIPOutputStream(buffer));){
            writer.write((JsonStructure)jsonObject);
        }
        VarInt.encode((long)buffer.getCounter(), (OutputStream)outputStream);
        outputStream.write(buffer.toByteArray());
    }

    public JsonObject decode(InputStream inputStream) throws IOException {
        long maxBytes = VarInt.decodeLong((InputStream)inputStream);
        try (JsonReader reader = this.readerFactory.createReader((InputStream)new GZIPInputStream(new NoCloseInputStream(inputStream, maxBytes)));){
            JsonObject jsonObject;
            JsonObject jsonObject2 = jsonObject = reader.readObject();
            return jsonObject2;
        }
    }

    public boolean equals(Object obj) {
        return JsonpJsonObjectCoder.class.isInstance(obj) && ((JsonpJsonObjectCoder)((Object)JsonpJsonObjectCoder.class.cast(obj))).isValid();
    }

    public int hashCode() {
        return JsonpJsonObjectCoder.class.hashCode();
    }

    private boolean isValid() {
        return this.readerFactory != null && this.writerFactory != null;
    }

    public static JsonpJsonObjectCoder of(String plugin) {
        if (plugin == null) {
            ComponentManager instance = ComponentManager.instance();
            return new JsonpJsonObjectCoder(instance.getJsonpReaderFactory(), instance.getJsonpWriterFactory());
        }
        LightContainer container = ContainerFinder.Instance.get().find(plugin);
        return new JsonpJsonObjectCoder((JsonReaderFactory)container.findService(JsonReaderFactory.class), (JsonWriterFactory)container.findService(JsonWriterFactory.class));
    }

    @Generated
    private JsonpJsonObjectCoder(JsonReaderFactory readerFactory, JsonWriterFactory writerFactory) {
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
    }

    @Generated
    protected JsonpJsonObjectCoder() {
    }
}

