/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform.avro;

import java.util.Arrays;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.runtime.beam.transform.avro.JsonIndexedRecord;

public class SchemalessJsonToIndexedRecord
extends PTransform<PCollection<JsonObject>, PCollection<IndexedRecord>> {
    private static final String NAMESPACE = "org.talend.generated.json2avro";
    private String rootRecordName;

    public PCollection<IndexedRecord> expand(PCollection<JsonObject> input) {
        return (PCollection)input.apply("SchemalessJsonToIndexedRecord", (PTransform)ParDo.of((DoFn)new Fn("org.talend.generated.json2avro." + this.rootRecordName)));
    }

    public SchemalessJsonToIndexedRecord(String rootRecordName) {
        this.rootRecordName = rootRecordName;
    }

    public static class Fn
    extends DoFn<JsonObject, IndexedRecord> {
        private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
        private static final Schema BOOLEAN = Schema.create((Schema.Type)Schema.Type.BOOLEAN);
        private static final Schema DOUBLE = Schema.create((Schema.Type)Schema.Type.DOUBLE);
        private static final Schema LONG = Schema.create((Schema.Type)Schema.Type.LONG);
        private static final Schema INT = Schema.create((Schema.Type)Schema.Type.INT);
        private static final Schema STRING = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.STRING), Schema.create((Schema.Type)Schema.Type.NULL)));
        private final String rootRecordName;

        @DoFn.ProcessElement
        public void onRecord(DoFn.ProcessContext context) {
            JsonObject element = (JsonObject)context.element();
            context.output((Object)this.toAvro(element));
        }

        public JsonIndexedRecord toAvro(JsonObject element) {
            return new JsonIndexedRecord(element, this.guessSchema(this.rootRecordName, (JsonValue)element));
        }

        private Schema guessSchema(String recordName, JsonValue element) {
            switch (element.getValueType()) {
                case STRING: {
                    return STRING;
                }
                case NUMBER: {
                    Number number = ((JsonNumber)JsonNumber.class.cast(element)).numberValue();
                    if (Long.class.isInstance(number)) {
                        return LONG;
                    }
                    if (Integer.class.isInstance(number)) {
                        return INT;
                    }
                    return DOUBLE;
                }
                case FALSE: 
                case TRUE: {
                    return BOOLEAN;
                }
                case NULL: {
                    return NULL;
                }
                case OBJECT: {
                    Schema record = Schema.createRecord((String)recordName, null, (String)SchemalessJsonToIndexedRecord.NAMESPACE, (boolean)false);
                    record.setFields(element.asJsonObject().entrySet().stream().map(it -> new Schema.Field((String)it.getKey(), this.guessSchema(this.buildNextName(recordName, (String)it.getKey()), (JsonValue)it.getValue()), null, null)).collect(Collectors.toList()));
                    return record;
                }
                case ARRAY: {
                    JsonArray array = element.asJsonArray();
                    if (!array.isEmpty()) {
                        return Schema.createArray((Schema)this.guessSchema(this.buildNextName(recordName, "Array"), (JsonValue)array.iterator().next()));
                    }
                    return Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.NULL));
                }
            }
            throw new IllegalArgumentException("Unsupported: " + element.toString());
        }

        private String buildNextName(String recordName, String key) {
            if (key.isEmpty()) {
                return recordName + "Empty";
            }
            String normalized = key.replaceAll("[^a-zA-Z0-9]", "");
            return recordName + Character.toUpperCase(normalized.charAt(0)) + normalized.substring(1);
        }

        public Fn(String rootRecordName) {
            this.rootRecordName = rootRecordName;
        }
    }
}

