/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.record.SchemaImpl;

public class AvroSchemaCache {
    private static final int MAX_SIZE = 5;
    private final Function<SchemaImpl, AvroSchema> transform;
    private final ConcurrentMap<SchemaImpl, ChronoValue> cache = new ConcurrentHashMap<SchemaImpl, ChronoValue>(5);

    public AvroSchema find(Schema schema) {
        if (schema == null || schema instanceof AvroSchema) {
            return (AvroSchema)schema;
        }
        if (schema instanceof SchemaImpl) {
            SchemaImpl realSchema = (SchemaImpl)schema;
            if (!this.cache.containsKey(realSchema) && this.cache.size() >= 5) {
                this.removeOldest();
            }
            ChronoValue chronoValue = this.cache.computeIfAbsent(realSchema, this.transform.andThen(ChronoValue::new));
            return chronoValue.getSchema();
        }
        return null;
    }

    private synchronized void removeOldest() {
        while (this.cache.size() >= 5) {
            Optional<Map.Entry> oldest = this.cache.entrySet().stream().min(Comparator.comparing(e -> ((ChronoValue)e.getValue()).getLastUsage()));
            if (!oldest.isPresent()) continue;
            SchemaImpl key = (SchemaImpl)oldest.get().getKey();
            this.cache.remove(key);
        }
    }

    public AvroSchemaCache(Function<SchemaImpl, AvroSchema> transform) {
        this.transform = transform;
    }

    private static class ChronoValue {
        private final AvroSchema schema;
        private Long lastUsage = System.currentTimeMillis();

        public AvroSchema getSchema() {
            this.lastUsage = System.currentTimeMillis();
            return this.schema;
        }

        public ChronoValue(AvroSchema schema) {
            this.schema = schema;
        }

        Long getLastUsage() {
            return this.lastUsage;
        }
    }
}

