/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform;

import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.beam.spi.record.RecordCollectors;
import org.talend.sdk.component.runtime.beam.transform.RecordParDoTransformCoderProvider;
import org.talend.sdk.component.runtime.beam.transform.service.ServiceLookup;
import org.talend.sdk.component.runtime.manager.ComponentManager;

public class RecordBranchMapper
extends DoFn<Record, Record> {
    private RecordBuilderFactory factory;
    private String sourceBranch;
    private String targetBranch;

    public RecordBranchMapper(RecordBuilderFactory factory, String sourceBranch, String targetBranch) {
        this.factory = factory;
        this.sourceBranch = Schema.sanitizeConnectionName((String)sourceBranch);
        this.targetBranch = Schema.sanitizeConnectionName((String)targetBranch);
    }

    protected RecordBranchMapper() {
    }

    @DoFn.ProcessElement
    public void onElement(DoFn.ProcessContext context) {
        Record aggregate = (Record)context.element();
        Collection branch = aggregate.getArray(Record.class, this.sourceBranch);
        if (branch != null) {
            Record output = aggregate.getSchema().getAllEntries().collect(() -> ((RecordBuilderFactory)this.factory).newRecordBuilder(), (a, e) -> {
                boolean remappedBranch = e.getName().equals(this.sourceBranch);
                String branchName = remappedBranch ? this.targetBranch : e.getName();
                a.withArray(this.factory.newEntryBuilder().withName(branchName).withType(Schema.Type.ARRAY).withElementSchema(e.getElementSchema()).build(), remappedBranch ? branch : aggregate.getArray(Record.class, e.getName()));
            }, RecordCollectors::merge).build();
            context.output((Object)output);
        } else {
            context.output((Object)aggregate);
        }
    }

    public static PTransform<PCollection<Record>, PCollection<Record>> of(String plugin, String fromBranch, String toBranch) {
        RecordBuilderFactory lookup = ServiceLookup.lookup(ComponentManager.instance(), plugin, RecordBuilderFactory.class);
        return new RecordParDoTransformCoderProvider<Record>((Coder<Record>)SchemaRegistryCoder.of(), new RecordBranchMapper(lookup, fromBranch, toBranch));
    }
}

