/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform.avro;

import java.util.stream.Collectors;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;

public class JsonIndexedRecord
extends GenericData.Record {
    private final JsonObject object;

    public JsonIndexedRecord(JsonObject object, Schema schema) {
        super(schema);
        this.object = object;
    }

    public void put(int i, Object v) {
        throw new UnsupportedOperationException("readonly structure");
    }

    public Object get(int i) {
        Schema.Field field = (Schema.Field)this.getSchema().getFields().get(i);
        return this.toObject((JsonValue)this.object.get((Object)field.name()), field.schema());
    }

    private Object toObject(JsonValue jsonValue, Schema schema) {
        if (jsonValue == null) {
            return null;
        }
        switch (jsonValue.getValueType()) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NUMBER: {
                return ((JsonNumber)JsonNumber.class.cast(jsonValue)).numberValue();
            }
            case STRING: {
                return ((JsonString)JsonString.class.cast(jsonValue)).getString();
            }
            case ARRAY: {
                return jsonValue.asJsonArray().stream().map(it -> this.toObject(jsonValue, schema.getElementType())).collect(Collectors.toList());
            }
            case OBJECT: {
                return new JsonIndexedRecord(jsonValue.asJsonObject(), schema);
            }
        }
        return null;
    }

    public JsonObject getObject() {
        return this.object;
    }
}

