/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform;

import java.util.Collection;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistryCoder;
import org.talend.sdk.component.runtime.beam.transform.RecordParDoTransformCoderProvider;
import org.talend.sdk.component.runtime.beam.transform.service.ServiceLookup;
import org.talend.sdk.component.runtime.manager.ComponentManager;

public class RecordBranchFilter
extends DoFn<Record, Record> {
    private RecordBuilderFactory factory;
    private String branch;

    public RecordBranchFilter(RecordBuilderFactory factory, String branch) {
        this.factory = factory;
        this.branch = Schema.sanitizeConnectionName((String)branch);
    }

    protected RecordBranchFilter() {
    }

    @DoFn.ProcessElement
    public void onElement(DoFn.ProcessContext context) {
        Record aggregate = (Record)context.element();
        Collection branchValue = aggregate.getArray(Record.class, this.branch);
        if (branchValue != null) {
            Schema.Entry entry = aggregate.getSchema().getEntries().stream().filter(it -> it.getName().equals(this.branch)).findFirst().get();
            context.output((Object)this.factory.newRecordBuilder().withArray(entry, branchValue).build());
        }
    }

    public static PTransform<PCollection<Record>, PCollection<Record>> of(String plugin, String branchSelector) {
        RecordBuilderFactory lookup = ServiceLookup.lookup(ComponentManager.instance(), plugin, RecordBuilderFactory.class);
        return new RecordParDoTransformCoderProvider<Record>((Coder<Record>)SchemaRegistryCoder.of(), new RecordBranchFilter(lookup, branchSelector));
    }
}

