/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.beam.sdk.coders.CustomCoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.coder.registry.AvroCoderCache;
import org.talend.sdk.component.runtime.beam.coder.registry.SchemaRegistry;
import org.talend.sdk.component.runtime.beam.spi.record.AvroRecord;
import org.talend.sdk.component.runtime.beam.spi.record.SchemaIdGenerator;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.Schemas;

public class SchemaRegistryCoder
extends CustomCoder<Record> {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryCoder.class);
    private static final GenericData.Record EMPTY_RECORD = new GenericData.Record(AvroSchemas.getEmptySchema());

    public void encode(Record value, OutputStream outputStream) throws IOException {
        Schemas schema = value == null ? Schemas.EMPTY_RECORD : value.getSchema();
        Schema avro = value == null ? AvroSchemas.getEmptySchema() : (Schema)((Unwrappable)Unwrappable.class.cast(schema)).unwrap(Schema.class);
        String id = SchemaIdGenerator.generateRecordName(avro.getFields());
        outputStream.write(id.getBytes(StandardCharsets.UTF_8));
        outputStream.write(10);
        this.registry().putIfAbsent(id, (org.talend.sdk.component.api.record.Schema)schema);
        if (value != null) {
            AvroCoderCache.getCoder(avro).encode(((Unwrappable)Unwrappable.class.cast(value)).unwrap(IndexedRecord.class), outputStream);
        }
        outputStream.flush();
    }

    public Record decode(InputStream inputStream) throws IOException {
        int b;
        ByteArrayOutputStream firstLineData = new ByteArrayOutputStream();
        while ((b = inputStream.read()) >= 0 && b != 10) {
            firstLineData.write(b);
        }
        String id = firstLineData.toString("UTF-8");
        org.talend.sdk.component.api.record.Schema schema = this.registry().get(id);
        if (schema == null) {
            throw new IllegalStateException("Invalid schema id: '" + id + "'");
        }
        Schema unwrappedSchema = (Schema)((Unwrappable)Unwrappable.class.cast(schema)).unwrap(Schema.class);
        if (Schemas.EMPTY_RECORD == schema) {
            return new AvroRecord((IndexedRecord)EMPTY_RECORD);
        }
        IndexedRecord decoded = (IndexedRecord)AvroCoderCache.getCoder(unwrappedSchema).decode(inputStream);
        return new AvroRecord(decoded);
    }

    public int hashCode() {
        return SchemaRegistryCoder.class.hashCode();
    }

    public boolean equals(Object obj) {
        return SchemaRegistryCoder.class.isInstance(obj);
    }

    private SchemaRegistry registry() {
        return SchemaRegistry.Instance.get();
    }

    public static SchemaRegistryCoder of() {
        return new SchemaRegistryCoder();
    }
}

