/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder.registry;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.coder.registry.InMemorySchemaRegistry;

public interface SchemaRegistry {
    public void putIfAbsent(String var1, Schema var2);

    public Schema get(String var1);

    public static class Instance {
        private static final SchemaRegistry REGISTRY = Instance.load();

        public static SchemaRegistry get() {
            return REGISTRY;
        }

        private static SchemaRegistry load() {
            Iterator<SchemaRegistry> iterator = ServiceLoader.load(SchemaRegistry.class).iterator();
            if (iterator.hasNext()) {
                SchemaRegistry schemaRegistry = iterator.next();
                if (iterator.hasNext()) {
                    throw new IllegalStateException("Ambiguous schema registry: " + schemaRegistry + "/" + iterator.next());
                }
                return schemaRegistry;
            }
            return new InMemorySchemaRegistry();
        }

        private Instance() {
        }
    }
}

