/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.avro;

import java.util.Collections;
import org.apache.avro.Schema;

public final class AvroSchemas {
    private static final Schema EMPTY_SCHEMA = Schema.createRecord((String)"org.talend.sdk.component.schema.generated.EmptyRecord", null, null, (boolean)false);

    public static Schema unwrapUnion(Schema schema) {
        switch (schema.getType()) {
            case UNION: {
                return schema.getTypes().stream().filter(it -> it.getType() != Schema.Type.NULL).findFirst().orElse(null);
            }
        }
        return schema;
    }

    public static Schema getEmptySchema() {
        return EMPTY_SCHEMA;
    }

    public static String sanitizeConnectionName(String name) {
        char[] sanitized;
        if (name.isEmpty()) {
            return name;
        }
        char[] original = name.toCharArray();
        boolean skipFirstChar = !Character.isLetter(original[0]) && original[0] != '_';
        int offset = skipFirstChar ? 1 : 0;
        char[] cArray = sanitized = skipFirstChar ? new char[original.length - offset] : new char[original.length];
        if (!skipFirstChar) {
            sanitized[0] = original[0];
        }
        for (int i = 1; i < original.length; ++i) {
            sanitized[i - offset] = !Character.isLetterOrDigit(original[i]) && original[i] != '_' ? 95 : original[i];
        }
        return new String(sanitized);
    }

    public static Schema.Field addProp(Schema.Field field, String key, String value) {
        if (value != null) {
            field.addProp(key, value);
        }
        return field;
    }

    private AvroSchemas() {
    }

    static {
        EMPTY_SCHEMA.setFields(Collections.emptyList());
    }
}

