/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.impl;

import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.state.Timer;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Instant;
import org.talend.sdk.component.runtime.beam.impl.ContextImplGenericsHolder;
import org.talend.sdk.component.runtime.beam.impl.OutputReceiver;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;

public class InMemoryArgumentProvider
implements DoFnInvoker.ArgumentProvider {
    private final PipelineOptions options;
    private final ContextImplGenericsHolder contextImplGenericsHolder = new ContextImplGenericsHolder();
    private InputFactory inputs;
    private OutputFactory outputs;

    public BoundedWindow window() {
        return GlobalWindow.INSTANCE;
    }

    public PipelineOptions pipelineOptions() {
        return this.options;
    }

    public DoFn.ProcessContext processContext(DoFn doFn) {
        return this.contextImplGenericsHolder.newContext(this.options, this.inputs, this.outputs);
    }

    public DoFn.StartBundleContext startBundleContext(DoFn doFn) {
        return this.contextImplGenericsHolder.newStartContext(this.options);
    }

    public DoFn.FinishBundleContext finishBundleContext(DoFn doFn) {
        return this.contextImplGenericsHolder.newFinishContext(this.options, this.outputs);
    }

    public PaneInfo paneInfo(DoFn doFn) {
        return PaneInfo.NO_FIRING;
    }

    public Object element(DoFn doFn) {
        return this.inputs.read("__default__");
    }

    public DoFn.OutputReceiver outputReceiver(DoFn doFn) {
        return new OutputReceiver(this.outputs, "__default__");
    }

    public DoFn.OutputReceiver<Row> outputRowReceiver(DoFn doFn) {
        throw new UnsupportedOperationException("Schemas are not supported");
    }

    public DoFn.MultiOutputReceiver taggedOutputReceiver(DoFn doFn) {
        return new DoFn.MultiOutputReceiver(){

            public <T> DoFn.OutputReceiver<T> get(TupleTag<T> tag) {
                return new OutputReceiver(InMemoryArgumentProvider.this.outputs, tag.getId());
            }

            public <T> DoFn.OutputReceiver<Row> getRowReceiver(TupleTag<T> tag) {
                throw new UnsupportedOperationException("Schemas are not supported");
            }
        };
    }

    public Instant timestamp(DoFn doFn) {
        return Instant.now();
    }

    public Row asRow(String id) {
        throw new UnsupportedOperationException("Schemas are not supported");
    }

    public TimeDomain timeDomain(DoFn doFn) {
        return TimeDomain.PROCESSING_TIME;
    }

    public DoFn.OnTimerContext onTimerContext(DoFn doFn) {
        throw new UnsupportedOperationException("Unsupported on timer usage");
    }

    public RestrictionTracker<?, ?> restrictionTracker() {
        throw new UnsupportedOperationException("Unsupported restriction tracker usage");
    }

    public State state(String stateId) {
        throw new UnsupportedOperationException("Unsupported state tracker usage");
    }

    public Timer timer(String timerId) {
        throw new UnsupportedOperationException("Unsupported timer tracker usage");
    }

    public InMemoryArgumentProvider(PipelineOptions options) {
        this.options = options;
    }

    public void setInputs(InputFactory inputs) {
        this.inputs = inputs;
    }

    public void setOutputs(OutputFactory outputs) {
        this.outputs = outputs;
    }
}

