/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.factory.service;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.xbean.propertyeditor.PropertyEditorException;
import org.apache.xbean.propertyeditor.PropertyEditors;

public class AutoValueFluentApiFactory
implements Serializable {
    public <T> T create(Class<T> base, String factoryMethod, Map<String, Object> config) {
        try {
            Method method = this.findFactory(base, factoryMethod);
            return base.cast(this.setConfig(method.invoke(null, new Object[0]), config, ""));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    private <T> Method findFactory(Class<T> base, String name) {
        return Stream.of(base.getMethods()).filter(m -> name.equals(m.getName())).min(new FactorySorter()).orElseGet(() -> (Method)Optional.ofNullable(base.getEnclosingClass()).flatMap(c -> Stream.of(c.getMethods()).filter(m -> name.equals(m.getName())).min(new FactorySorter())).orElseThrow(() -> new IllegalArgumentException("No factory '" + name + "' in " + base)));
    }

    private Object setConfig(Object root, Map<String, Object> config, String prefix) {
        Object io = root;
        Map potentialConfigs = Stream.of(io.getClass().getMethods()).filter(m -> m.getName().length() > 5 && (m.getName().startsWith("with") || m.getName().startsWith("set")) && m.getParameters().length == 1 && m.getReturnType().isInstance(root)).collect(Collectors.toMap(m -> Introspector.decapitalize(m.getName().startsWith("with") ? m.getName().substring("with".length()) : m.getName().substring("set".length())), Function.identity(), (method1, method2) -> {
            if (Class.class.isInstance(method1.getGenericParameterTypes()[0])) {
                return method1;
            }
            if (Class.class.isInstance(method2.getGenericParameterTypes()[0])) {
                return method2;
            }
            if (method1.toGenericString().compareTo(method2.toGenericString()) < 0) {
                return method1;
            }
            return method2;
        }));
        for (Map.Entry entry : potentialConfigs.entrySet()) {
            Method wither;
            Type paramType;
            String configKey = entry.getKey();
            Object value = this.createValue(config, prefix, configKey, paramType = (wither = (Method)entry.getValue()).getParameters()[0].getParameterizedType());
            if (value == null) continue;
            io = this.with(io, wither, value);
        }
        return io;
    }

    private Object createValue(Map<String, Object> config, String prefix, String configKey, Type paramType) {
        Object value = config.get(configKey);
        if (value != null) {
            value = this.createPrimitiveValue(value, paramType);
        } else {
            String filter = prefix + configKey + '.';
            Map<String, Object> subObjectConfig = config.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(filter)).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(filter.length()), Map.Entry::getValue));
            if (!subObjectConfig.isEmpty()) {
                value = this.createObjectValue(subObjectConfig, paramType, prefix);
            }
        }
        return value;
    }

    private Object createObjectValue(Map<String, Object> config, Type paramType, String prefix) {
        if (!Class.class.isInstance(paramType)) {
            throw new IllegalArgumentException("Unsupported type: " + paramType);
        }
        Method factory = this.findFactory((Class)Class.class.cast(paramType), "create");
        List params = Stream.of(factory.getParameters()).map(p -> new AbstractMap.SimpleEntry<String, Object>(p.getName(), this.createValue(config, prefix, p.getName(), p.getParameterizedType()))).collect(Collectors.toList());
        try {
            return this.setConfig(factory.invoke(null, (Object[])params.stream().map(Map.Entry::getValue).toArray(Object[]::new)), config, prefix);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    private Object with(Object io, Method wither, Object arg) {
        try {
            return wither.invoke(io, arg);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getTargetException());
        }
    }

    private Object createPrimitiveValue(Object v, Type type) {
        ParameterizedType pt;
        Type raw;
        if (String.class == type) {
            return v;
        }
        if (Class.class.isInstance(type) && ((Class)Class.class.cast(type)).isInstance(v)) {
            return v;
        }
        if (ParameterizedType.class.isInstance(type) && Class.class.isInstance(raw = (pt = (ParameterizedType)ParameterizedType.class.cast(type)).getRawType()) && ((Class)Class.class.cast(raw)).isInstance(v)) {
            return v;
        }
        try {
            return PropertyEditors.getValue((Type)type, (String)v.toString());
        }
        catch (PropertyEditorException pee) {
            throw new IllegalArgumentException(pee);
        }
    }

    private static class FactorySorter
    implements Comparator<Method> {
        private FactorySorter() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            int supportedParams1 = this.countSupportedParams(o1);
            if (supportedParams1 == o1.getParameterCount()) {
                return -1;
            }
            int supportedParams2 = this.countSupportedParams(o2);
            if (supportedParams2 == o2.getParameterCount()) {
                return 1;
            }
            int diff1 = o1.getParameterCount() - supportedParams1;
            int diff2 = o2.getParameterCount() - supportedParams2;
            return diff2 - diff1;
        }

        private int countSupportedParams(Method mtd) {
            return (int)Stream.of(mtd.getParameters()).filter(p -> PropertyEditors.canConvert(p.getType())).count();
        }
    }
}

