/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.transform.avro;

import javax.json.JsonObject;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.talend.sdk.component.runtime.beam.transform.avro.JsonIndexedRecord;

public class JsonToIndexedRecord
extends PTransform<PCollection<JsonObject>, PCollection<IndexedRecord>> {
    private final Schema outputSchema;

    public PCollection<IndexedRecord> expand(PCollection<JsonObject> input) {
        return (PCollection)input.apply("JsonToIndexedRecord", (PTransform)ParDo.of((DoFn)new Fn(this.outputSchema.toString())));
    }

    protected Coder<?> getDefaultOutputCoder() {
        return AvroCoder.of((Schema)this.outputSchema);
    }

    public JsonToIndexedRecord(Schema outputSchema) {
        this.outputSchema = outputSchema;
    }

    public static class Fn
    extends DoFn<JsonObject, IndexedRecord> {
        private final String schemaJson;
        private Schema schema;

        @DoFn.Setup
        public void setup() {
            this.schema = new Schema.Parser().parse(this.schemaJson);
        }

        @DoFn.ProcessElement
        public void onRecord(DoFn.ProcessContext context) {
            context.output((Object)new JsonIndexedRecord((JsonObject)context.element(), this.schema));
        }

        public Fn(String schemaJson) {
            this.schemaJson = schemaJson;
        }
    }
}

