/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.coder;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class ContextualSerializableCoder<T extends Serializable>
extends SerializableCoder<T> {
    private String plugin;

    protected ContextualSerializableCoder() {
        super(null, null);
    }

    private ContextualSerializableCoder(Class<T> type, TypeDescriptor<T> typeDescriptor, String plugin) {
        super(type, typeDescriptor);
        this.plugin = plugin;
    }

    public static <T extends Serializable> SerializableCoder<T> of(Class<T> type, String plugin) {
        return new ContextualSerializableCoder<T>(type, TypeDescriptor.of(type), plugin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encode(T value, OutputStream outStream) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        LightContainer container = this.getContainer();
        thread.setContextClassLoader(container.classloader());
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outStream);
            objectOutputStream.writeObject(value);
            objectOutputStream.flush();
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public T decode(InputStream inStream) throws IOException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        LightContainer container = this.getContainer();
        thread.setContextClassLoader(container.classloader());
        try {
            EnhancedObjectInputStream objectInputStream = new EnhancedObjectInputStream(inStream, container.classloader());
            Serializable serializable = (Serializable)objectInputStream.readObject();
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw new CoderException((Throwable)e);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    public boolean equals(Object other) {
        return other != null && ((Object)((Object)this)).getClass() == other.getClass() && this.getRecordType() == ((ContextualSerializableCoder)((Object)ContextualSerializableCoder.class.cast(other))).getRecordType();
    }

    public int hashCode() {
        return this.getRecordType().hashCode();
    }

    public String toString() {
        return "ContextualSerializableCoder{plugin='" + this.plugin + "', clazz=" + this.getRecordType().getName() + "}";
    }

    private LightContainer getContainer() {
        return ContainerFinder.Instance.get().find(this.plugin);
    }

    Object writeReplace() throws ObjectStreamException {
        return new Replacer(this.plugin, this.getRecordType().getName());
    }

    private static class Replacer
    implements Serializable {
        private final String plugin;
        private final String className;

        Object readResolve() throws ObjectStreamException {
            ContainerFinder containerFinder = ContainerFinder.Instance.get();
            LightContainer container = containerFinder.find(this.plugin);
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            ClassLoader classLoader = container.classloader();
            thread.setContextClassLoader(classLoader);
            try {
                Class<?> clazz = classLoader.loadClass(this.className);
                SerializableCoder<?> serializableCoder = ContextualSerializableCoder.of(clazz, this.plugin);
                return serializableCoder;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(this.className + " not found", e);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }

        public Replacer(String plugin, String className) {
            this.plugin = plugin;
            this.className = className;
        }
    }
}

