/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi.record;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.runtime.beam.avro.AvroSchemas;
import org.talend.sdk.component.runtime.beam.spi.record.AvroPropertyMapper;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchema;
import org.talend.sdk.component.runtime.beam.spi.record.SchemaIdGenerator;
import org.talend.sdk.component.runtime.manager.service.api.Unwrappable;
import org.talend.sdk.component.runtime.record.Schemas;

public class AvroSchemaBuilder
implements Schema.Builder {
    private static final Schema NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final AvroSchema BYTES_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
    private static final AvroSchema INT_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.INT));
    private static final AvroSchema LONG_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.LONG));
    private static final AvroSchema DATETIME_SCHEMA = new AvroSchema(new AvroPropertyMapper(){}.setProp(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.Type.DATETIME.name(), "true"));
    private static final AvroSchema STRING_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.STRING));
    private static final AvroSchema DOUBLE_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.DOUBLE));
    private static final AvroSchema FLOAT_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.FLOAT));
    private static final AvroSchema BOOLEAN_SCHEMA = new AvroSchema(Schema.create((Schema.Type)Schema.Type.BOOLEAN));
    private static final AvroSchema BYTES_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.BYTES))));
    private static final AvroSchema INT_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.INT))));
    private static final AvroSchema LONG_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.LONG))));
    private static final AvroSchema DATETIME_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, new AvroPropertyMapper(){}.setProp(LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG)), Schema.Type.DATETIME.name(), "true"))));
    private static final AvroSchema STRING_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.STRING))));
    private static final AvroSchema DOUBLE_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.DOUBLE))));
    private static final AvroSchema FLOAT_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.FLOAT))));
    private static final AvroSchema BOOLEAN_SCHEMA_NULLABLE = new AvroSchema(Schema.createUnion(Arrays.asList(NULL_SCHEMA, Schema.create((Schema.Type)Schema.Type.BOOLEAN))));
    private List<Schema.Field> fields;
    private Schema.Type type;
    private org.talend.sdk.component.api.record.Schema elementSchema;

    public Schema.Builder withType(Schema.Type type) {
        this.type = type;
        return this;
    }

    public Schema.Builder withEntry(final Schema.Entry entry) {
        AvroSchema unwrappable;
        if (this.type != Schema.Type.RECORD) {
            throw new IllegalArgumentException("entry is only valid for RECORD type of schema");
        }
        if (this.fields == null) {
            this.fields = new ArrayList<Schema.Field>();
        }
        switch (entry.getType()) {
            case RECORD: {
                unwrappable = (Unwrappable)Unwrappable.class.cast(entry.getElementSchema());
                break;
            }
            case ARRAY: {
                unwrappable = new Unwrappable(){

                    public <T> T unwrap(Class<T> type) {
                        return type.cast(Schema.createArray((Schema)((Schema)((Unwrappable)Unwrappable.class.cast(entry.getElementSchema())).unwrap(Schema.class))));
                    }
                };
                break;
            }
            case BOOLEAN: {
                unwrappable = !entry.isNullable() ? BOOLEAN_SCHEMA : BOOLEAN_SCHEMA_NULLABLE;
                break;
            }
            case DOUBLE: {
                unwrappable = !entry.isNullable() ? DOUBLE_SCHEMA : DOUBLE_SCHEMA_NULLABLE;
                break;
            }
            case INT: {
                unwrappable = !entry.isNullable() ? INT_SCHEMA : INT_SCHEMA_NULLABLE;
                break;
            }
            case FLOAT: {
                unwrappable = !entry.isNullable() ? FLOAT_SCHEMA : FLOAT_SCHEMA_NULLABLE;
                break;
            }
            case BYTES: {
                unwrappable = !entry.isNullable() ? BYTES_SCHEMA : BYTES_SCHEMA_NULLABLE;
                break;
            }
            case LONG: {
                unwrappable = !entry.isNullable() ? LONG_SCHEMA : LONG_SCHEMA_NULLABLE;
                break;
            }
            case STRING: {
                unwrappable = !entry.isNullable() ? STRING_SCHEMA : STRING_SCHEMA_NULLABLE;
                break;
            }
            case DATETIME: {
                unwrappable = !entry.isNullable() ? DATETIME_SCHEMA : DATETIME_SCHEMA_NULLABLE;
                break;
            }
            default: {
                unwrappable = (Unwrappable)Unwrappable.class.cast(new AvroSchemaBuilder().withType(entry.getType()).build());
            }
        }
        Schema schema = (Schema)((Unwrappable)Unwrappable.class.cast(unwrappable)).unwrap(Schema.class);
        this.fields.add(new Schema.Field(AvroSchemas.sanitizeConnectionName(entry.getName()), entry.isNullable() && schema.getType() != Schema.Type.UNION ? Schema.createUnion(Arrays.asList(NULL_SCHEMA, schema)) : schema, entry.getComment(), entry.getDefaultValue()));
        return this;
    }

    public Schema.Builder withElementSchema(org.talend.sdk.component.api.record.Schema schema) {
        if (this.type != Schema.Type.ARRAY && schema != null) {
            throw new IllegalArgumentException("elementSchema is only valid for ARRAY type of schema");
        }
        this.elementSchema = schema;
        return this;
    }

    public org.talend.sdk.component.api.record.Schema build() {
        switch (this.type) {
            case BYTES: {
                return BYTES_SCHEMA;
            }
            case INT: {
                return INT_SCHEMA;
            }
            case LONG: {
                return LONG_SCHEMA;
            }
            case STRING: {
                return STRING_SCHEMA;
            }
            case DOUBLE: {
                return DOUBLE_SCHEMA;
            }
            case FLOAT: {
                return FLOAT_SCHEMA;
            }
            case BOOLEAN: {
                return BOOLEAN_SCHEMA;
            }
            case DATETIME: {
                return DATETIME_SCHEMA;
            }
            case RECORD: {
                if (this.fields == null) {
                    return new AvroSchema(AvroSchemas.getEmptySchema());
                }
                Schema record = Schema.createRecord((String)SchemaIdGenerator.generateRecordName(this.fields), null, (String)"talend.component.schema", (boolean)false);
                record.setFields(this.fields);
                return new AvroSchema(record);
            }
            case ARRAY: {
                if (this.elementSchema == null) {
                    throw new IllegalStateException("No elementSchema set for this ARRAY schema");
                }
                Schema elementType = this.elementSchema == Schemas.EMPTY_RECORD ? AvroSchemas.getEmptySchema() : (Schema)((Unwrappable)Unwrappable.class.cast(this.elementSchema)).unwrap(Schema.class);
                return new AvroSchema(Schema.createArray((Schema)elementType));
            }
        }
        throw new IllegalArgumentException("Unsupported: " + this.type);
    }
}

