/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.spi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.beam.spi.record.AvroRecordBuilder;
import org.talend.sdk.component.runtime.beam.spi.record.AvroSchemaBuilder;
import org.talend.sdk.component.runtime.manager.service.DefaultServices;
import org.talend.sdk.component.runtime.manager.service.record.RecordBuilderFactoryProvider;
import org.talend.sdk.component.runtime.record.SchemaImpl;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class AvroRecordBuilderFactoryProvider
implements RecordBuilderFactoryProvider {
    public RecordBuilderFactory apply(String containerId) {
        return new AvroRecordBuilderFactory(containerId);
    }

    private static class AvroRecordBuilderFactory
    implements RecordBuilderFactory,
    Serializable {
        private final String plugin;

        public Schema.Builder newSchemaBuilder(Schema.Type type) {
            return new AvroSchemaBuilder().withType(type);
        }

        public Record.Builder newRecordBuilder(Schema schema) {
            return new AvroRecordBuilder(schema);
        }

        public Record.Builder newRecordBuilder() {
            return new AvroRecordBuilder();
        }

        public Schema.Entry.Builder newEntryBuilder() {
            return new SchemaImpl.EntryImpl.BuilderImpl();
        }

        Object writeReplace() throws ObjectStreamException {
            if (this.plugin == null) {
                return DefaultServices.lookup((String)RecordBuilderFactory.class.getName());
            }
            return new SerializableService(this.plugin, RecordBuilderFactory.class.getName());
        }

        public AvroRecordBuilderFactory(String plugin) {
            this.plugin = plugin;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AvroRecordBuilderFactory)) {
                return false;
            }
            AvroRecordBuilderFactory other = (AvroRecordBuilderFactory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$plugin = this.getPlugin();
            String other$plugin = other.getPlugin();
            return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AvroRecordBuilderFactory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $plugin = this.getPlugin();
            result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
            return result;
        }

        public String toString() {
            return "AvroRecordBuilderFactoryProvider.AvroRecordBuilderFactory(plugin=" + this.getPlugin() + ")";
        }
    }
}

