/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.beam.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.beam.error.ErrorFactory;
import org.talend.sdk.component.runtime.beam.impl.SingleInputFactory;
import org.talend.sdk.component.runtime.beam.impl.StoringOuputFactory;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;

public class BeamInput
implements Input {
    private static final Logger log = LoggerFactory.getLogger(BeamInput.class);
    private final Source.Reader<?> reader;
    private final Processor processor;
    private final String plugin;
    private final String family;
    private final String name;
    private final ClassLoader loader;
    private final int chunkSize = 10;
    private final long retryOnNoRecordTimeoutSec;
    private boolean started;
    private int itemCounter = 0;
    private Iterator<Object> records;

    public Object next() {
        if (this.records != null && this.records.hasNext()) {
            return this.records.next();
        }
        return this.execute(() -> {
            try {
                boolean hasRecord;
                if (!this.started) {
                    hasRecord = this.reader.start();
                    if (this.processor != null) {
                        this.processor.start();
                    }
                    this.started = true;
                } else {
                    hasRecord = this.reader.advance();
                }
                if (this.itemCounter == 0 && this.processor != null) {
                    this.processor.beforeGroup();
                }
                if (!hasRecord && this.retryOnNoRecordTimeoutSec > 0L) {
                    long init = System.currentTimeMillis();
                    long maxRetryTimestamp = init + TimeUnit.SECONDS.toMillis(this.retryOnNoRecordTimeoutSec);
                    while (!hasRecord && System.currentTimeMillis() < maxRetryTimestamp) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            return null;
                        }
                        hasRecord = this.reader.advance();
                    }
                    if (!hasRecord) {
                        log.warn("No record in {} seconds, quitting", (Object)this.retryOnNoRecordTimeoutSec);
                    }
                }
                if (hasRecord) {
                    this.records = this.doTransform(this.reader.getCurrent());
                }
                if (this.processor != null && ++this.itemCounter > 10) {
                    this.afterChunk();
                }
                if (this.records != null && this.records.hasNext()) {
                    return this.records.next();
                }
            }
            catch (IOException e) {
                throw ErrorFactory.toIllegalState(e);
            }
            return null;
        });
    }

    public String plugin() {
        return this.plugin;
    }

    public String rootName() {
        return this.family;
    }

    public String name() {
        return this.name;
    }

    public void start() {
    }

    public void stop() {
        this.execute(() -> {
            if (this.started) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw ErrorFactory.toIllegalState(e);
                }
                finally {
                    if (this.processor != null) {
                        try {
                            if (this.itemCounter > 0) {
                                this.afterChunk();
                            }
                        }
                        finally {
                            this.processor.stop();
                        }
                    }
                }
            }
            return null;
        });
    }

    private void afterChunk() {
        this.processor.afterGroup(name -> value -> {
            throw new IllegalArgumentException("chunk outputs are not yet supported");
        });
        this.itemCounter = 0;
    }

    private <T> T execute(Supplier<T> task) {
        Thread thread = Thread.currentThread();
        ClassLoader tccl = thread.getContextClassLoader();
        thread.setContextClassLoader(this.loader);
        try {
            T t = task.get();
            return t;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            throw e;
        }
        catch (Exception ex) {
            throw ErrorFactory.toIllegalState(ex);
        }
        finally {
            thread.setContextClassLoader(tccl);
        }
    }

    private Iterator<Object> doTransform(Object current) {
        if (current == null || this.processor == null) {
            return new SingleElementIterator<Object>(current);
        }
        StoringOuputFactory output = new StoringOuputFactory();
        this.processor.onNext((InputFactory)new SingleInputFactory(current), (OutputFactory)output);
        if (output.getValues() != null) {
            return output.getValues().iterator();
        }
        return new SingleElementIterator<Object>(current);
    }

    public BeamInput(Source.Reader<?> reader, Processor processor, String plugin, String family, String name, ClassLoader loader, long retryOnNoRecordTimeoutSec) {
        this.reader = reader;
        this.processor = processor;
        this.plugin = plugin;
        this.family = family;
        this.name = name;
        this.loader = loader;
        this.retryOnNoRecordTimeoutSec = retryOnNoRecordTimeoutSec;
    }

    public Source.Reader<?> getReader() {
        return this.reader;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public String getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public long getRetryOnNoRecordTimeoutSec() {
        return this.retryOnNoRecordTimeoutSec;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getItemCounter() {
        return this.itemCounter;
    }

    public Iterator<Object> getRecords() {
        return this.records;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void setItemCounter(int itemCounter) {
        this.itemCounter = itemCounter;
    }

    public void setRecords(Iterator<Object> records) {
        this.records = records;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeamInput)) {
            return false;
        }
        BeamInput other = (BeamInput)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Source.Reader<?> this$reader = this.getReader();
        Source.Reader<?> other$reader = other.getReader();
        if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
            return false;
        }
        Processor this$processor = this.getProcessor();
        Processor other$processor = other.getProcessor();
        if (this$processor == null ? other$processor != null : !this$processor.equals(other$processor)) {
            return false;
        }
        String this$plugin = this.getPlugin();
        String other$plugin = other.getPlugin();
        if (this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin)) {
            return false;
        }
        String this$family = this.getFamily();
        String other$family = other.getFamily();
        if (this$family == null ? other$family != null : !this$family.equals(other$family)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ClassLoader this$loader = this.getLoader();
        ClassLoader other$loader = other.getLoader();
        if (this$loader == null ? other$loader != null : !this$loader.equals(other$loader)) {
            return false;
        }
        if (this.getChunkSize() != other.getChunkSize()) {
            return false;
        }
        if (this.getRetryOnNoRecordTimeoutSec() != other.getRetryOnNoRecordTimeoutSec()) {
            return false;
        }
        if (this.isStarted() != other.isStarted()) {
            return false;
        }
        if (this.getItemCounter() != other.getItemCounter()) {
            return false;
        }
        Iterator<Object> this$records = this.getRecords();
        Iterator<Object> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !this$records.equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeamInput;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Source.Reader<?> $reader = this.getReader();
        result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
        Processor $processor = this.getProcessor();
        result = result * 59 + ($processor == null ? 43 : $processor.hashCode());
        String $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        String $family = this.getFamily();
        result = result * 59 + ($family == null ? 43 : $family.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ClassLoader $loader = this.getLoader();
        result = result * 59 + ($loader == null ? 43 : $loader.hashCode());
        result = result * 59 + this.getChunkSize();
        long $retryOnNoRecordTimeoutSec = this.getRetryOnNoRecordTimeoutSec();
        result = result * 59 + (int)($retryOnNoRecordTimeoutSec >>> 32 ^ $retryOnNoRecordTimeoutSec);
        result = result * 59 + (this.isStarted() ? 79 : 97);
        result = result * 59 + this.getItemCounter();
        Iterator<Object> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : $records.hashCode());
        return result;
    }

    public String toString() {
        return "BeamInput(reader=" + this.getReader() + ", processor=" + this.getProcessor() + ", plugin=" + this.getPlugin() + ", family=" + this.getFamily() + ", name=" + this.getName() + ", loader=" + this.getLoader() + ", chunkSize=" + this.getChunkSize() + ", retryOnNoRecordTimeoutSec=" + this.getRetryOnNoRecordTimeoutSec() + ", started=" + this.isStarted() + ", itemCounter=" + this.getItemCounter() + ", records=" + this.getRecords() + ")";
    }

    private static class SingleElementIterator<T>
    implements Iterator<T> {
        private final T element;
        private boolean done;

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public T next() {
            if (this.done) {
                throw new NoSuchElementException();
            }
            try {
                T t = this.element;
                return t;
            }
            finally {
                this.done = true;
            }
        }

        public SingleElementIterator(T element) {
            this.element = element;
        }

        public T getElement() {
            return this.element;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleElementIterator)) {
                return false;
            }
            SingleElementIterator other = (SingleElementIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$element = this.getElement();
            T other$element = other.getElement();
            if (this$element == null ? other$element != null : !this$element.equals(other$element)) {
                return false;
            }
            return this.isDone() == other.isDone();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SingleElementIterator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $element = this.getElement();
            result = result * 59 + ($element == null ? 43 : $element.hashCode());
            result = result * 59 + (this.isDone() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "BeamInput.SingleElementIterator(element=" + this.getElement() + ", done=" + this.isDone() + ")";
        }
    }
}

