/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.service.http.configurer.oauth1;

import java.security.PrivateKey;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import lombok.Generated;
import org.talend.sdk.component.api.meta.Internal;
import org.talend.sdk.component.api.meta.Partial;
import org.talend.sdk.component.api.service.http.Configurer;

@Partial(value="This doesn't fully implement oauth1 yet but is a good example of configurer entry point")
public final class OAuth1 {
    public Map<String, String> buildParameters(String method, String url, byte[] payload, Configuration oauth1Config) {
        return OAuth1.loadProvider().buildParameters(method, url, payload, oauth1Config);
    }

    private static OAuth1Provider loadProvider() {
        Iterator<OAuth1Provider> iterator = ServiceLoader.load(OAuth1Provider.class).iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No registered implementation of OAuth1Provider");
        }
        return iterator.next();
    }

    @Generated
    private OAuth1() {
    }

    @Internal
    public static interface OAuth1Provider {
        public Map<String, String> buildParameters(String var1, String var2, byte[] var3, Configuration var4);

        public org.talend.sdk.component.api.service.http.Configurer newConfigurer();
    }

    public static class Configuration {
        private String header;
        private String headerPrefix;
        private String payloadHashAlgorithm;
        private String algorithm;
        private byte[] signingHmacKey;
        private PrivateKey signingSignatureKey;
        private Map<String, String> oauthParameters;
        private String token;
        private String tokenSecret;
        private String consumerKey;
        private String consumerSecret;
        private String nonce;
        private Long timestamp;

        @Generated
        Configuration(String header, String headerPrefix, String payloadHashAlgorithm, String algorithm, byte[] signingHmacKey, PrivateKey signingSignatureKey, Map<String, String> oauthParameters, String token, String tokenSecret, String consumerKey, String consumerSecret, String nonce, Long timestamp) {
            this.header = header;
            this.headerPrefix = headerPrefix;
            this.payloadHashAlgorithm = payloadHashAlgorithm;
            this.algorithm = algorithm;
            this.signingHmacKey = signingHmacKey;
            this.signingSignatureKey = signingSignatureKey;
            this.oauthParameters = oauthParameters;
            this.token = token;
            this.tokenSecret = tokenSecret;
            this.consumerKey = consumerKey;
            this.consumerSecret = consumerSecret;
            this.nonce = nonce;
            this.timestamp = timestamp;
        }

        @Generated
        public static ConfigurationBuilder builder() {
            return new ConfigurationBuilder();
        }

        @Generated
        public String getHeader() {
            return this.header;
        }

        @Generated
        public String getHeaderPrefix() {
            return this.headerPrefix;
        }

        @Generated
        public String getPayloadHashAlgorithm() {
            return this.payloadHashAlgorithm;
        }

        @Generated
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Generated
        public byte[] getSigningHmacKey() {
            return this.signingHmacKey;
        }

        @Generated
        public PrivateKey getSigningSignatureKey() {
            return this.signingSignatureKey;
        }

        @Generated
        public Map<String, String> getOauthParameters() {
            return this.oauthParameters;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public String getTokenSecret() {
            return this.tokenSecret;
        }

        @Generated
        public String getConsumerKey() {
            return this.consumerKey;
        }

        @Generated
        public String getConsumerSecret() {
            return this.consumerSecret;
        }

        @Generated
        public String getNonce() {
            return this.nonce;
        }

        @Generated
        public Long getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public void setHeader(String header) {
            this.header = header;
        }

        @Generated
        public void setHeaderPrefix(String headerPrefix) {
            this.headerPrefix = headerPrefix;
        }

        @Generated
        public void setPayloadHashAlgorithm(String payloadHashAlgorithm) {
            this.payloadHashAlgorithm = payloadHashAlgorithm;
        }

        @Generated
        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Generated
        public void setSigningHmacKey(byte[] signingHmacKey) {
            this.signingHmacKey = signingHmacKey;
        }

        @Generated
        public void setSigningSignatureKey(PrivateKey signingSignatureKey) {
            this.signingSignatureKey = signingSignatureKey;
        }

        @Generated
        public void setOauthParameters(Map<String, String> oauthParameters) {
            this.oauthParameters = oauthParameters;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setTokenSecret(String tokenSecret) {
            this.tokenSecret = tokenSecret;
        }

        @Generated
        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }

        @Generated
        public void setConsumerSecret(String consumerSecret) {
            this.consumerSecret = consumerSecret;
        }

        @Generated
        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        @Generated
        public void setTimestamp(Long timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$timestamp = this.getTimestamp();
            Long other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            String this$header = this.getHeader();
            String other$header = other.getHeader();
            if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
                return false;
            }
            String this$headerPrefix = this.getHeaderPrefix();
            String other$headerPrefix = other.getHeaderPrefix();
            if (this$headerPrefix == null ? other$headerPrefix != null : !this$headerPrefix.equals(other$headerPrefix)) {
                return false;
            }
            String this$payloadHashAlgorithm = this.getPayloadHashAlgorithm();
            String other$payloadHashAlgorithm = other.getPayloadHashAlgorithm();
            if (this$payloadHashAlgorithm == null ? other$payloadHashAlgorithm != null : !this$payloadHashAlgorithm.equals(other$payloadHashAlgorithm)) {
                return false;
            }
            String this$algorithm = this.getAlgorithm();
            String other$algorithm = other.getAlgorithm();
            if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
                return false;
            }
            if (!Arrays.equals(this.getSigningHmacKey(), other.getSigningHmacKey())) {
                return false;
            }
            PrivateKey this$signingSignatureKey = this.getSigningSignatureKey();
            PrivateKey other$signingSignatureKey = other.getSigningSignatureKey();
            if (this$signingSignatureKey == null ? other$signingSignatureKey != null : !this$signingSignatureKey.equals(other$signingSignatureKey)) {
                return false;
            }
            Map<String, String> this$oauthParameters = this.getOauthParameters();
            Map<String, String> other$oauthParameters = other.getOauthParameters();
            if (this$oauthParameters == null ? other$oauthParameters != null : !((Object)this$oauthParameters).equals(other$oauthParameters)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$tokenSecret = this.getTokenSecret();
            String other$tokenSecret = other.getTokenSecret();
            if (this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret)) {
                return false;
            }
            String this$consumerKey = this.getConsumerKey();
            String other$consumerKey = other.getConsumerKey();
            if (this$consumerKey == null ? other$consumerKey != null : !this$consumerKey.equals(other$consumerKey)) {
                return false;
            }
            String this$consumerSecret = this.getConsumerSecret();
            String other$consumerSecret = other.getConsumerSecret();
            if (this$consumerSecret == null ? other$consumerSecret != null : !this$consumerSecret.equals(other$consumerSecret)) {
                return false;
            }
            String this$nonce = this.getNonce();
            String other$nonce = other.getNonce();
            return !(this$nonce == null ? other$nonce != null : !this$nonce.equals(other$nonce));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            String $header = this.getHeader();
            result = result * 59 + ($header == null ? 43 : $header.hashCode());
            String $headerPrefix = this.getHeaderPrefix();
            result = result * 59 + ($headerPrefix == null ? 43 : $headerPrefix.hashCode());
            String $payloadHashAlgorithm = this.getPayloadHashAlgorithm();
            result = result * 59 + ($payloadHashAlgorithm == null ? 43 : $payloadHashAlgorithm.hashCode());
            String $algorithm = this.getAlgorithm();
            result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
            result = result * 59 + Arrays.hashCode(this.getSigningHmacKey());
            PrivateKey $signingSignatureKey = this.getSigningSignatureKey();
            result = result * 59 + ($signingSignatureKey == null ? 43 : $signingSignatureKey.hashCode());
            Map<String, String> $oauthParameters = this.getOauthParameters();
            result = result * 59 + ($oauthParameters == null ? 43 : ((Object)$oauthParameters).hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $tokenSecret = this.getTokenSecret();
            result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
            String $consumerKey = this.getConsumerKey();
            result = result * 59 + ($consumerKey == null ? 43 : $consumerKey.hashCode());
            String $consumerSecret = this.getConsumerSecret();
            result = result * 59 + ($consumerSecret == null ? 43 : $consumerSecret.hashCode());
            String $nonce = this.getNonce();
            result = result * 59 + ($nonce == null ? 43 : $nonce.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OAuth1.Configuration(header=" + this.getHeader() + ", headerPrefix=" + this.getHeaderPrefix() + ", payloadHashAlgorithm=" + this.getPayloadHashAlgorithm() + ", algorithm=" + this.getAlgorithm() + ", signingHmacKey=" + Arrays.toString(this.getSigningHmacKey()) + ", signingSignatureKey=" + this.getSigningSignatureKey() + ", oauthParameters=" + this.getOauthParameters() + ", token=" + this.getToken() + ", tokenSecret=" + this.getTokenSecret() + ", consumerKey=" + this.getConsumerKey() + ", consumerSecret=" + this.getConsumerSecret() + ", nonce=" + this.getNonce() + ", timestamp=" + this.getTimestamp() + ")";
        }

        @Generated
        public static class ConfigurationBuilder {
            @Generated
            private String header;
            @Generated
            private String headerPrefix;
            @Generated
            private String payloadHashAlgorithm;
            @Generated
            private String algorithm;
            @Generated
            private byte[] signingHmacKey;
            @Generated
            private PrivateKey signingSignatureKey;
            @Generated
            private Map<String, String> oauthParameters;
            @Generated
            private String token;
            @Generated
            private String tokenSecret;
            @Generated
            private String consumerKey;
            @Generated
            private String consumerSecret;
            @Generated
            private String nonce;
            @Generated
            private Long timestamp;

            @Generated
            ConfigurationBuilder() {
            }

            @Generated
            public ConfigurationBuilder header(String header) {
                this.header = header;
                return this;
            }

            @Generated
            public ConfigurationBuilder headerPrefix(String headerPrefix) {
                this.headerPrefix = headerPrefix;
                return this;
            }

            @Generated
            public ConfigurationBuilder payloadHashAlgorithm(String payloadHashAlgorithm) {
                this.payloadHashAlgorithm = payloadHashAlgorithm;
                return this;
            }

            @Generated
            public ConfigurationBuilder algorithm(String algorithm) {
                this.algorithm = algorithm;
                return this;
            }

            @Generated
            public ConfigurationBuilder signingHmacKey(byte[] signingHmacKey) {
                this.signingHmacKey = signingHmacKey;
                return this;
            }

            @Generated
            public ConfigurationBuilder signingSignatureKey(PrivateKey signingSignatureKey) {
                this.signingSignatureKey = signingSignatureKey;
                return this;
            }

            @Generated
            public ConfigurationBuilder oauthParameters(Map<String, String> oauthParameters) {
                this.oauthParameters = oauthParameters;
                return this;
            }

            @Generated
            public ConfigurationBuilder token(String token) {
                this.token = token;
                return this;
            }

            @Generated
            public ConfigurationBuilder tokenSecret(String tokenSecret) {
                this.tokenSecret = tokenSecret;
                return this;
            }

            @Generated
            public ConfigurationBuilder consumerKey(String consumerKey) {
                this.consumerKey = consumerKey;
                return this;
            }

            @Generated
            public ConfigurationBuilder consumerSecret(String consumerSecret) {
                this.consumerSecret = consumerSecret;
                return this;
            }

            @Generated
            public ConfigurationBuilder nonce(String nonce) {
                this.nonce = nonce;
                return this;
            }

            @Generated
            public ConfigurationBuilder timestamp(Long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            @Generated
            public Configuration build() {
                return new Configuration(this.header, this.headerPrefix, this.payloadHashAlgorithm, this.algorithm, this.signingHmacKey, this.signingSignatureKey, this.oauthParameters, this.token, this.tokenSecret, this.consumerKey, this.consumerSecret, this.nonce, this.timestamp);
            }

            @Generated
            public String toString() {
                return "OAuth1.Configuration.ConfigurationBuilder(header=" + this.header + ", headerPrefix=" + this.headerPrefix + ", payloadHashAlgorithm=" + this.payloadHashAlgorithm + ", algorithm=" + this.algorithm + ", signingHmacKey=" + Arrays.toString(this.signingHmacKey) + ", signingSignatureKey=" + this.signingSignatureKey + ", oauthParameters=" + this.oauthParameters + ", token=" + this.token + ", tokenSecret=" + this.tokenSecret + ", consumerKey=" + this.consumerKey + ", consumerSecret=" + this.consumerSecret + ", nonce=" + this.nonce + ", timestamp=" + this.timestamp + ")";
            }
        }
    }

    public static class Configurer
    implements org.talend.sdk.component.api.service.http.Configurer {
        @Override
        public void configure(Configurer.Connection connection, Configurer.ConfigurerConfiguration configuration) {
            OAuth1.loadProvider().newConfigurer().configure(connection, configuration);
        }
    }
}

