/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import org.talend.sdk.component.api.record.Schema;

public interface Record {
    public static final String RECORD_ERROR_SUPPORT = "talend.component.record.error.support";

    public Schema getSchema();

    default public Builder withNewSchema(Schema schema) {
        throw new UnsupportedOperationException("#withNewSchema is not implemented");
    }

    public <T> T get(Class<T> var1, String var2);

    default public <T> T get(Class<T> expectedType, Schema.Entry entry) {
        if (entry == null) {
            return null;
        }
        return this.get(expectedType, entry.getName());
    }

    default public String getString(String name) {
        return this.get(String.class, name);
    }

    default public int getInt(String name) {
        return this.get(Integer.class, name);
    }

    default public long getLong(String name) {
        return this.get(Long.class, name);
    }

    default public double getDouble(String name) {
        return this.get(Double.class, name);
    }

    default public float getFloat(String name) {
        return this.get(Float.class, name).floatValue();
    }

    default public boolean getBoolean(String name) {
        return this.get(Boolean.class, name);
    }

    default public byte[] getBytes(String name) {
        return this.get(byte[].class, name);
    }

    default public Record getRecord(String name) {
        return this.get(Record.class, name);
    }

    default public <T> Collection<T> getArray(Class<T> type, String name) {
        return this.get(Collection.class, name);
    }

    default public ZonedDateTime getDateTime(String name) {
        return this.get(ZonedDateTime.class, name);
    }

    default public Instant getInstant(String name) {
        return this.get(Instant.class, name);
    }

    default public BigDecimal getDecimal(String name) {
        return this.get(BigDecimal.class, name);
    }

    default public <T> Optional<Collection<T>> getOptionalArray(Class<T> type, String name) {
        Collection value = this.get(Collection.class, name);
        return Optional.ofNullable(value);
    }

    default public Optional<ZonedDateTime> getOptionalDateTime(String name) {
        return Optional.ofNullable(this.get(ZonedDateTime.class, name));
    }

    default public Optional<Instant> getOptionalInstant(String name) {
        return Optional.ofNullable(this.get(Instant.class, name));
    }

    default public Optional<BigDecimal> getOptionalDecimal(String name) {
        return Optional.ofNullable(this.get(BigDecimal.class, name));
    }

    default public Optional<String> getOptionalString(String name) {
        return Optional.ofNullable(this.get(String.class, name));
    }

    default public OptionalInt getOptionalInt(String name) {
        Integer value = this.get(Integer.class, name);
        return value == null ? OptionalInt.empty() : OptionalInt.of(value);
    }

    default public OptionalLong getOptionalLong(String name) {
        Long value = this.get(Long.class, name);
        return value == null ? OptionalLong.empty() : OptionalLong.of(value);
    }

    default public OptionalDouble getOptionalDouble(String name) {
        Double value = this.get(Double.class, name);
        return value == null ? OptionalDouble.empty() : OptionalDouble.of(value);
    }

    default public OptionalDouble getOptionalFloat(String name) {
        Float value = this.get(Float.class, name);
        return value == null ? OptionalDouble.empty() : OptionalDouble.of(value.floatValue());
    }

    default public Optional<Boolean> getOptionalBoolean(String name) {
        return Optional.ofNullable(this.get(Boolean.class, name));
    }

    default public Optional<byte[]> getOptionalBytes(String name) {
        return Optional.ofNullable(this.get(byte[].class, name));
    }

    default public Optional<Record> getOptionalRecord(String name) {
        return Optional.ofNullable(this.get(Record.class, name));
    }

    default public boolean isValid() {
        return !this.getSchema().getAllEntries().anyMatch(entry -> !entry.isValid());
    }

    public static interface Builder {
        public Record build();

        public Object getValue(String var1);

        public List<Schema.Entry> getCurrentEntries();

        default public Schema.Entry getEntry(String name) {
            return this.getCurrentEntries().stream().filter(e -> name.equals(e.getName())).findFirst().orElse(null);
        }

        default public Builder before(String entryName) {
            throw new UnsupportedOperationException("#before is not implemented");
        }

        default public Builder after(String entryName) {
            throw new UnsupportedOperationException("#after");
        }

        public Builder removeEntry(Schema.Entry var1);

        public Builder updateEntryByName(String var1, Schema.Entry var2);

        default public Builder updateEntryByName(String name, Schema.Entry schemaEntry, Function<Object, Object> valueCastFunction) {
            throw new UnsupportedOperationException("#updateEntryByName");
        }

        public Builder with(Schema.Entry var1, Object var2);

        public Builder withString(String var1, String var2);

        public Builder withString(Schema.Entry var1, String var2);

        public Builder withBytes(String var1, byte[] var2);

        public Builder withBytes(Schema.Entry var1, byte[] var2);

        public Builder withDateTime(String var1, Date var2);

        public Builder withDateTime(Schema.Entry var1, Date var2);

        public Builder withDateTime(String var1, ZonedDateTime var2);

        public Builder withDateTime(Schema.Entry var1, ZonedDateTime var2);

        default public Builder withDecimal(String name, BigDecimal value) {
            throw new UnsupportedOperationException("#withDecimal");
        }

        default public Builder withDecimal(Schema.Entry entry, BigDecimal value) {
            throw new UnsupportedOperationException("#withDecimal");
        }

        public Builder withTimestamp(String var1, long var2);

        public Builder withTimestamp(Schema.Entry var1, long var2);

        default public Builder withInstant(String name, Instant value) {
            throw new UnsupportedOperationException("#withInstant");
        }

        default public Builder withInstant(Schema.Entry entry, Instant value) {
            throw new UnsupportedOperationException("#withInstant");
        }

        public Builder withInt(String var1, int var2);

        public Builder withInt(Schema.Entry var1, int var2);

        public Builder withLong(String var1, long var2);

        public Builder withLong(Schema.Entry var1, long var2);

        public Builder withFloat(String var1, float var2);

        public Builder withFloat(Schema.Entry var1, float var2);

        public Builder withDouble(String var1, double var2);

        public Builder withDouble(Schema.Entry var1, double var2);

        public Builder withBoolean(String var1, boolean var2);

        public Builder withBoolean(Schema.Entry var1, boolean var2);

        public Builder withRecord(Schema.Entry var1, Record var2);

        public Builder withRecord(String var1, Record var2);

        public <T> Builder withArray(Schema.Entry var1, Collection<T> var2);
    }
}

