/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonValue;
import javax.json.bind.annotation.JsonbTransient;
import org.talend.sdk.component.api.record.Record;

public interface Schema {
    public Type getType();

    public Schema getElementSchema();

    public List<Entry> getEntries();

    public List<Entry> getMetadata();

    public Stream<Entry> getAllEntries();

    public Builder toBuilder();

    default public List<Entry> getEntriesOrdered() {
        return this.getEntriesOrdered(this.naturalOrder());
    }

    @JsonbTransient
    default public List<Entry> getEntriesOrdered(Comparator<Entry> comparator) {
        return this.getAllEntries().sorted(comparator).collect(Collectors.toList());
    }

    public EntriesOrder naturalOrder();

    default public Entry getEntry(String name) {
        return this.getAllEntries().filter(e -> Objects.equals(e.getName(), name)).findFirst().orElse(null);
    }

    public Map<String, String> getProps();

    public String getProp(String var1);

    default public JsonValue getJsonProp(String name) {
        String prop = this.getProp(name);
        if (prop == null) {
            return null;
        }
        try {
            return Json.createParser((Reader)new StringReader(prop)).getValue();
        }
        catch (RuntimeException ex) {
            return Json.createValue((String)prop);
        }
    }

    public static String sanitizeConnectionName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        char current = name.charAt(0);
        CharsetEncoder ascii = Charset.forName(StandardCharsets.US_ASCII.name()).newEncoder();
        boolean skipFirstChar = (!ascii.canEncode(current) || !Character.isLetter(current) && current != '_') && name.length() > 1 && !Character.isDigit(name.charAt(1));
        StringBuilder sanitizedBuilder = new StringBuilder();
        if (!skipFirstChar) {
            if (!Character.isLetter(current) && current != '_' || !ascii.canEncode(current)) {
                sanitizedBuilder.append('_');
            } else {
                sanitizedBuilder.append(current);
            }
        }
        for (int i = 1; i < name.length(); ++i) {
            current = name.charAt(i);
            if (!ascii.canEncode(current)) {
                if (Character.isLowerCase(current) || Character.isUpperCase(current)) {
                    sanitizedBuilder.append('_');
                    continue;
                }
                byte[] encoded = Base64.getEncoder().encode(name.substring(i, i + 1).getBytes(StandardCharsets.UTF_8));
                String enc = new String(encoded);
                if (sanitizedBuilder.length() == 0 && Character.isDigit(enc.charAt(0))) {
                    sanitizedBuilder.append('_');
                }
                for (int iter = 0; iter < enc.length(); ++iter) {
                    if (Character.isLetterOrDigit(enc.charAt(iter))) {
                        sanitizedBuilder.append(enc.charAt(iter));
                        continue;
                    }
                    sanitizedBuilder.append('_');
                }
                continue;
            }
            if (Character.isLetterOrDigit(current)) {
                sanitizedBuilder.append(current);
                continue;
            }
            sanitizedBuilder.append('_');
        }
        return sanitizedBuilder.toString();
    }

    public static Entry avoidCollision(Entry newEntry, Supplier<Stream<Entry>> allEntriesSupplier, BiConsumer<String, Entry> replaceFunction) {
        boolean matchedToChange;
        Optional<Entry> collisionedEntry = allEntriesSupplier.get().filter(field -> field.getName().equals(newEntry.getName()) && !Objects.equals(field, newEntry)).findFirst();
        if (!collisionedEntry.isPresent()) {
            return newEntry;
        }
        Entry matchedEntry = collisionedEntry.get();
        boolean bl = matchedToChange = matchedEntry.getRawName() != null && !matchedEntry.getRawName().isEmpty();
        if (matchedToChange) {
            replaceFunction.accept(matchedEntry.getName(), newEntry);
        } else if (newEntry.getRawName() == null || newEntry.getRawName().isEmpty()) {
            return null;
        }
        Entry fieldToChange = matchedToChange ? matchedEntry : newEntry;
        int indexForAnticollision = 1;
        String baseName = Schema.sanitizeConnectionName(fieldToChange.getRawName());
        String newName = baseName + "_" + indexForAnticollision;
        Set existingNames = allEntriesSupplier.get().map(Entry::getName).collect(Collectors.toSet());
        while (existingNames.contains(newName)) {
            newName = baseName + "_" + ++indexForAnticollision;
        }
        Entry newFieldToAdd = fieldToChange.toBuilder().withName(newName).build();
        return newFieldToAdd;
    }

    public static class EntriesOrder
    implements Comparator<Entry> {
        private final List<String> fieldsOrder;

        public static EntriesOrder of(String fields) {
            return new EntriesOrder(fields);
        }

        public EntriesOrder(String fields) {
            this.fieldsOrder = fields == null ? Collections.emptyList() : Arrays.stream(fields.split(",")).collect(Collectors.toList());
        }

        public EntriesOrder moveAfter(String after, String name) {
            if (this.getFieldsOrder().indexOf(after) == -1) {
                throw new IllegalArgumentException(String.format("%s not in schema", after));
            }
            this.getFieldsOrder().remove(name);
            int destination = this.getFieldsOrder().indexOf(after);
            if (destination + 1 != this.getFieldsOrder().size()) {
                ++destination;
            }
            this.getFieldsOrder().add(destination, name);
            return this;
        }

        public EntriesOrder moveBefore(String before, String name) {
            if (this.getFieldsOrder().indexOf(before) == -1) {
                throw new IllegalArgumentException(String.format("%s not in schema", before));
            }
            this.getFieldsOrder().remove(name);
            this.getFieldsOrder().add(this.getFieldsOrder().indexOf(before), name);
            return this;
        }

        public EntriesOrder swap(String name, String with) {
            Collections.swap(this.getFieldsOrder(), this.getFieldsOrder().indexOf(name), this.getFieldsOrder().indexOf(with));
            return this;
        }

        public String toFields() {
            return this.getFieldsOrder().stream().collect(Collectors.joining(","));
        }

        @Override
        public int compare(Entry e1, Entry e2) {
            int index1 = this.getFieldsOrder().indexOf(e1.getName());
            int index2 = this.getFieldsOrder().indexOf(e2.getName());
            if (index1 >= 0 && index2 >= 0) {
                return index1 - index2;
            }
            if (index1 >= 0) {
                return -1;
            }
            if (index2 >= 0) {
                return 1;
            }
            return 0;
        }

        public EntriesOrder(List<String> fieldsOrder) {
            this.fieldsOrder = fieldsOrder;
        }

        public String toString() {
            return "Schema.EntriesOrder(fieldsOrder=" + this.getFieldsOrder() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntriesOrder)) {
                return false;
            }
            EntriesOrder other = (EntriesOrder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$fieldsOrder = this.getFieldsOrder();
            List<String> other$fieldsOrder = other.getFieldsOrder();
            return !(this$fieldsOrder == null ? other$fieldsOrder != null : !((Object)this$fieldsOrder).equals(other$fieldsOrder));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntriesOrder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $fieldsOrder = this.getFieldsOrder();
            result = result * 59 + ($fieldsOrder == null ? 43 : ((Object)$fieldsOrder).hashCode());
            return result;
        }

        public List<String> getFieldsOrder() {
            return this.fieldsOrder;
        }
    }

    public static interface Builder {
        public Builder withType(Type var1);

        public Builder withEntry(Entry var1);

        public Builder withEntryAfter(String var1, Entry var2);

        public Builder withEntryBefore(String var1, Entry var2);

        public Builder remove(String var1);

        public Builder remove(Entry var1);

        public Builder moveAfter(String var1, String var2);

        public Builder moveBefore(String var1, String var2);

        public Builder swap(String var1, String var2);

        public Builder withElementSchema(Schema var1);

        public Builder withProps(Map<String, String> var1);

        public Builder withProp(String var1, String var2);

        public Schema build();
    }

    public static interface Entry {
        public String getName();

        public String getRawName();

        public String getOriginalFieldName();

        public Type getType();

        public boolean isNullable();

        public boolean isMetadata();

        public <T> T getDefaultValue();

        public Schema getElementSchema();

        public String getComment();

        public Map<String, String> getProps();

        public String getProp(String var1);

        default public JsonValue getJsonProp(String name) {
            String prop = this.getProp(name);
            if (prop == null) {
                return null;
            }
            try {
                return Json.createParser((Reader)new StringReader(prop)).getValue();
            }
            catch (RuntimeException ex) {
                return Json.createValue((String)prop);
            }
        }

        public Builder toBuilder();

        public static interface Builder {
            public Builder withName(String var1);

            public Builder withRawName(String var1);

            public Builder withType(Type var1);

            public Builder withNullable(boolean var1);

            public Builder withMetadata(boolean var1);

            public <T> Builder withDefaultValue(T var1);

            public Builder withElementSchema(Schema var1);

            public Builder withComment(String var1);

            public Builder withProps(Map<String, String> var1);

            public Builder withProp(String var1, String var2);

            public Entry build();
        }
    }

    public static enum Type {
        RECORD(new Class[]{Record.class}),
        ARRAY(new Class[]{Collection.class}),
        STRING(new Class[]{String.class}),
        BYTES(new Class[]{byte[].class, Byte[].class}),
        INT(new Class[]{Integer.class}),
        LONG(new Class[]{Long.class}),
        FLOAT(new Class[]{Float.class}),
        DOUBLE(new Class[]{Double.class}),
        BOOLEAN(new Class[]{Boolean.class}),
        DATETIME(new Class[]{Long.class, Date.class, Temporal.class});

        private final Class<?>[] classes;

        private Type(Class<?>[] classes) {
            this.classes = classes;
        }

        public boolean isCompatible(Object input) {
            if (input == null) {
                return true;
            }
            for (Class<?> clazz : this.classes) {
                if (!clazz.isInstance(input)) continue;
                return true;
            }
            return false;
        }
    }
}

