/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.api.record;

import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonValue;
import org.talend.sdk.component.api.record.Record;

public interface Schema {
    public Type getType();

    public Schema getElementSchema();

    public List<Entry> getEntries();

    public List<Entry> getMetadata();

    public Stream<Entry> getAllEntries();

    default public Entry getEntry(String name) {
        return Optional.ofNullable(this.getEntries()).orElse(Collections.emptyList()).stream().filter(e -> Objects.equals(e.getName(), name)).findFirst().orElse(null);
    }

    public Map<String, String> getProps();

    public String getProp(String var1);

    default public JsonValue getJsonProp(String name) {
        String prop = this.getProp(name);
        if (prop == null) {
            return null;
        }
        try {
            return Json.createParser((Reader)new StringReader(prop)).getValue();
        }
        catch (RuntimeException ex) {
            return Json.createValue((String)prop);
        }
    }

    public static String sanitizeConnectionName(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        char current = name.charAt(0);
        CharsetEncoder ascii = Charset.forName(StandardCharsets.US_ASCII.name()).newEncoder();
        boolean skipFirstChar = (!ascii.canEncode(current) || !Character.isLetter(current) && current != '_') && name.length() > 1 && !Character.isDigit(name.charAt(1));
        StringBuilder sanitizedBuilder = new StringBuilder();
        if (!skipFirstChar) {
            if (!Character.isLetter(current) && current != '_' || !ascii.canEncode(current)) {
                sanitizedBuilder.append('_');
            } else {
                sanitizedBuilder.append(current);
            }
        }
        for (int i = 1; i < name.length(); ++i) {
            current = name.charAt(i);
            if (!ascii.canEncode(current)) {
                if (Character.isLowerCase(current) || Character.isUpperCase(current)) {
                    sanitizedBuilder.append('_');
                    continue;
                }
                byte[] encoded = Base64.getEncoder().encode(name.substring(i, i + 1).getBytes(StandardCharsets.UTF_8));
                String enc = new String(encoded);
                if (sanitizedBuilder.length() == 0 && Character.isDigit(enc.charAt(0))) {
                    sanitizedBuilder.append('_');
                }
                for (int iter = 0; iter < enc.length(); ++iter) {
                    if (Character.isLetterOrDigit(enc.charAt(iter))) {
                        sanitizedBuilder.append(enc.charAt(iter));
                        continue;
                    }
                    sanitizedBuilder.append('_');
                }
                continue;
            }
            if (Character.isLetterOrDigit(current)) {
                sanitizedBuilder.append(current);
                continue;
            }
            sanitizedBuilder.append('_');
        }
        return sanitizedBuilder.toString();
    }

    public static interface Builder {
        public Builder withType(Type var1);

        public Builder withEntry(Entry var1);

        public Builder withElementSchema(Schema var1);

        public Builder withProps(Map<String, String> var1);

        public Builder withProp(String var1, String var2);

        public Schema build();
    }

    public static interface Entry {
        public String getName();

        public String getRawName();

        public String getOriginalFieldName();

        public Type getType();

        public boolean isNullable();

        public boolean isMetadata();

        public <T> T getDefaultValue();

        public Schema getElementSchema();

        public String getComment();

        public Map<String, String> getProps();

        public String getProp(String var1);

        default public JsonValue getJsonProp(String name) {
            String prop = this.getProp(name);
            if (prop == null) {
                return null;
            }
            try {
                return Json.createParser((Reader)new StringReader(prop)).getValue();
            }
            catch (RuntimeException ex) {
                return Json.createValue((String)prop);
            }
        }

        public static interface Builder {
            public Builder withName(String var1);

            public Builder withRawName(String var1);

            public Builder withType(Type var1);

            public Builder withNullable(boolean var1);

            public Builder withMetadata(boolean var1);

            public <T> Builder withDefaultValue(T var1);

            public Builder withElementSchema(Schema var1);

            public Builder withComment(String var1);

            public Builder withProps(Map<String, String> var1);

            public Builder withProp(String var1, String var2);

            public Entry build();
        }
    }

    public static enum Type {
        RECORD(new Class[]{Record.class}),
        ARRAY(new Class[]{Collection.class}),
        STRING(new Class[]{String.class}),
        BYTES(new Class[]{byte[].class, Byte[].class}),
        INT(new Class[]{Integer.class}),
        LONG(new Class[]{Long.class}),
        FLOAT(new Class[]{Float.class}),
        DOUBLE(new Class[]{Double.class}),
        BOOLEAN(new Class[]{Boolean.class}),
        DATETIME(new Class[]{Long.class, Date.class, Temporal.class});

        private final Class<?>[] classes;

        private Type(Class<?>[] classes) {
            this.classes = classes;
        }

        public boolean isCompatible(Object input) {
            if (input == null) {
                return true;
            }
            for (Class<?> clazz : this.classes) {
                if (!clazz.isInstance(input)) continue;
                return true;
            }
            return false;
        }
    }
}

