/**
 * Copyright (C) 2006-2021 Talend Inc. - www.talend.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.talend.sdk.component.api.component;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.talend.sdk.component.api.meta.Documentation;

@Documentation("Set the component version and optionally a way to migrate the incoming configuration on the fly.")
@Target(TYPE)
@Retention(RUNTIME)
public @interface Version {

    /**
     * @return the current version of the component.
     */
    int value() default 1;

    /**
     * @return the handler able ot migrate properties from one version to another one.
     */
    Class<? extends MigrationHandler> migrationHandler() default MigrationHandler.class;
}
