/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLException;
import oracle.xml.binxml.BinXMLMetadataProvider;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLSchema;
import oracle.xml.binxml.BinXMLStream;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.binxml.DBBinXMLMetadataProviderImpl;
import org.xml.sax.EntityResolver;

public class BinXMLVocabularyManager {
    Hashtable URLVocabId;
    Hashtable vocabIdBinXMLSchema;
    Hashtable vocabIdBinDTD;
    BinXMLMetadataProvider metaProvider;
    EntityResolver entresolver;
    boolean isSchemaAware;
    BinXMLSchema curbxschema;
    boolean debug = false;

    void setIsSchemaAware(boolean bl) {
        this.isSchemaAware = bl;
    }

    void setMetadataProvider(BinXMLMetadataProvider binXMLMetadataProvider) {
        this.metaProvider = binXMLMetadataProvider;
    }

    public void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    private void setCurrentBinXMLSchema(BinXMLSchema binXMLSchema) {
        this.curbxschema = binXMLSchema;
    }

    BinXMLSchema getCurrentBinXMLSchema() {
        return this.curbxschema;
    }

    BinXMLVocabId saveSchema(URL uRL) throws BinXMLException {
        return this.saveSchema(uRL.toExternalForm());
    }

    BinXMLVocabId saveSchema(String string) throws BinXMLException {
        return this.metaProvider.saveSchema(string);
    }

    public BinXMLVocabId registerSchema(URL uRL) throws BinXMLException {
        BinXMLVocabId binXMLVocabId = this.getBinXMLVocabIdfromURL(uRL);
        if (binXMLVocabId != null) {
            return binXMLVocabId;
        }
        BinXMLSchema binXMLSchema = this.annotateSchema(uRL);
        this.setCurrentBinXMLSchema(binXMLSchema);
        binXMLVocabId = this.createVocabID(binXMLSchema);
        this.URLVocabId.put(uRL, binXMLVocabId);
        if (this.vocabIdBinXMLSchema == null) {
            this.vocabIdBinXMLSchema = new Hashtable(20, 0.5f);
        }
        this.vocabIdBinXMLSchema.put(binXMLVocabId, binXMLSchema);
        binXMLSchema.setSchemaId(binXMLVocabId);
        return binXMLVocabId;
    }

    BinXMLVocabId registerSchema(URL uRL, Reader reader) throws BinXMLException {
        BinXMLVocabId binXMLVocabId = this.getBinXMLVocabIdfromURL(uRL);
        if (binXMLVocabId != null) {
            return binXMLVocabId;
        }
        BinXMLSchema binXMLSchema = this.annotateSchema(uRL, reader);
        this.setCurrentBinXMLSchema(binXMLSchema);
        binXMLVocabId = this.metaProvider instanceof DBBinXMLMetadataProviderImpl ? ((DBBinXMLMetadataProviderImpl)this.metaProvider).getSchemaID(uRL.toExternalForm()) : this.createVocabID(binXMLSchema);
        this.URLVocabId.put(uRL, binXMLVocabId);
        if (this.vocabIdBinXMLSchema == null) {
            this.vocabIdBinXMLSchema = new Hashtable(20, 0.5f);
        }
        this.vocabIdBinXMLSchema.put(binXMLVocabId, binXMLSchema);
        binXMLSchema.setSchemaId(binXMLVocabId);
        return binXMLVocabId;
    }

    BinXMLVocabId registerDTD(URL uRL) throws BinXMLException {
        return null;
    }

    BinXMLVocabId createVocabID(BinXMLSchema binXMLSchema) {
        byte[] byArray = new byte[16];
        int n = binXMLSchema.hashCode();
        byArray[0] = (byte)(n >> 0);
        byArray[1] = (byte)(n >> 4);
        byArray[2] = (byte)(n >> 8);
        byArray[3] = (byte)(n >> 12);
        BinXMLVocabId binXMLVocabId = new BinXMLVocabId();
        binXMLVocabId.setVocabID(byArray);
        return binXMLVocabId;
    }

    public BinXMLSchema getBinXMLSchema(BinXMLVocabId binXMLVocabId) {
        return (BinXMLSchema)this.vocabIdBinXMLSchema.get(binXMLVocabId);
    }

    public BinXMLSchema getBinXMLSchema(byte[] byArray) {
        Enumeration enumeration = this.vocabIdBinXMLSchema.keys();
        while (enumeration.hasMoreElements()) {
            BinXMLVocabId binXMLVocabId = (BinXMLVocabId)enumeration.nextElement();
            if (!this.compareByteArray(binXMLVocabId.getVocabID(), byArray)) continue;
            return (BinXMLSchema)this.vocabIdBinXMLSchema.get(binXMLVocabId);
        }
        return null;
    }

    private boolean compareByteArray(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (n = 0; n < byArray.length && byArray[n] == byArray2[n]; ++n) {
        }
        return n == byArray.length;
    }

    public BinXMLSchema getBinXMLSchema(URL uRL) {
        BinXMLVocabId binXMLVocabId = (BinXMLVocabId)this.URLVocabId.get(uRL);
        if (binXMLVocabId != null) {
            return this.getBinXMLSchema(binXMLVocabId);
        }
        return null;
    }

    public BinXMLSchema getBinXMLSchema(QName qName) {
        Enumeration enumeration = this.vocabIdBinXMLSchema.elements();
        while (enumeration.hasMoreElements()) {
            BinXMLSchema binXMLSchema = (BinXMLSchema)enumeration.nextElement();
            BinXMLProperty binXMLProperty = binXMLSchema.getRootElemProperty();
            if (!binXMLProperty.getQName().getNamespaceURI().equals(qName.getNamespaceURI()) || !binXMLProperty.getQName().getLocalPart().equals(qName.getLocalPart())) continue;
            return binXMLSchema;
        }
        return null;
    }

    BinXMLStream getBinaryDTD(BinXMLVocabId binXMLVocabId) {
        return null;
    }

    void setEntityResolver(EntityResolver entityResolver) {
        this.entresolver = entityResolver;
    }

    private BinXMLSchema annotateSchema(URL uRL) {
        BinXMLSchema binXMLSchema = new BinXMLSchema(uRL);
        binXMLSchema.setDebugMode(this.debug);
        binXMLSchema.annotate();
        if (this.debug) {
            binXMLSchema.showPropertySingleMappings();
            binXMLSchema.showPropertyParentMappings();
        }
        return binXMLSchema;
    }

    private BinXMLSchema annotateSchema(URL uRL, Reader reader) {
        BinXMLSchema binXMLSchema = new BinXMLSchema(uRL, reader);
        binXMLSchema.setDebugMode(this.debug);
        binXMLSchema.annotate();
        if (this.debug) {
            binXMLSchema.showPropertySingleMappings();
            binXMLSchema.showPropertyParentMappings();
        }
        return binXMLSchema;
    }

    private BinXMLVocabId getBinXMLVocabIdfromURL(URL uRL) {
        if (this.URLVocabId == null) {
            this.URLVocabId = new Hashtable(20, 0.5f);
            return null;
        }
        return (BinXMLVocabId)this.URLVocabId.get(uRL);
    }
}

