/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.binxml;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.namespace.QName;
import oracle.xml.binxml.BinXMLProperty;
import oracle.xml.binxml.BinXMLSchemaAnnotator;
import oracle.xml.binxml.BinXMLUtil;
import oracle.xml.binxml.BinXMLVocabId;
import oracle.xml.parser.schema.CSXConstants;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDAnnotation;
import oracle.xml.parser.schema.XSDAttribute;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDConstantValues;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDSimpleType;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.util.QxName;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BinXMLSchema
implements CSXConstants,
XSDConstantValues {
    boolean debug = false;
    BinXMLSchemaAnnotator annotator;
    Vector properties = new Vector(100, 50);
    Hashtable pkids = new Hashtable(20, 0.5f);
    Hashtable pkidsNonSeq;
    Hashtable pkidlist = new Hashtable(20, 0.5f);
    String rootprefix;
    BinXMLProperty rootprop;
    BinXMLVocabId sVocabID;
    XSDValidator validator;
    XMLSchema xmlschema;

    BinXMLSchema() {
        this.init();
    }

    BinXMLSchema(URL uRL) {
        this.init();
        this.annotator.setSchemaURL(uRL);
    }

    BinXMLSchema(URL uRL, Reader reader) {
        this.init();
        this.annotator.setSchemaURL(uRL);
        this.annotator.setSchemaReader(reader);
    }

    void setXMLSchema(XMLSchema xMLSchema) {
        this.xmlschema = xMLSchema;
    }

    void setDebugMode(boolean bl) {
        this.debug = bl;
    }

    boolean getDebugMode() {
        return this.debug;
    }

    public void setValidator(XSDValidator xSDValidator) {
        this.validator = xSDValidator;
    }

    XSDValidator getValidator() {
        return this.validator;
    }

    public BinXMLProperty getAttrProperty(String string, String string2) {
        XSDElement xSDElement = this.validator.getElementDeclaration();
        XSDAttribute xSDAttribute = xSDElement.getAttributeDeclaration(string, string2);
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            if (xSDAttribute != binXMLProperty.getXSDNode()) continue;
            binXMLProperty.setBinXMLSchema(this);
            return binXMLProperty;
        }
        return null;
    }

    public BinXMLProperty getCurrentProperty() {
        XSDElement xSDElement = this.validator.getElementDeclaration();
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            if (xSDElement != binXMLProperty.getXSDNode()) continue;
            binXMLProperty.setBinXMLSchema(this);
            return binXMLProperty;
        }
        if (xSDElement == null) {
            return null;
        }
        BinXMLProperty binXMLProperty = this.getRefProperty(xSDElement);
        binXMLProperty.setBinXMLSchema(this);
        return binXMLProperty;
    }

    private BinXMLProperty getRefProperty(XSDElement xSDElement) {
        String string = xSDElement.getRefLocalname();
        String string2 = xSDElement.getRefNamespace();
        XSDNode xSDNode = xSDElement.getType();
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            XSDNode xSDNode2 = binXMLProperty.getXSDNode();
            if (!(xSDNode2 instanceof XSDElement) || !binXMLProperty.getQName().getLocalPart().equals(string) || !binXMLProperty.getQName().getNamespaceURI().equals(string2) || ((XSDElement)xSDNode2).getType() != xSDNode) continue;
            return binXMLProperty;
        }
        return null;
    }

    public XMLSchema getXMLSchema() {
        return this.xmlschema;
    }

    private void init() {
        this.annotator = new BinXMLSchemaAnnotator();
        this.annotator.setBinXMLSchema(this);
    }

    Vector getBinXMLProperties() {
        return this.properties;
    }

    Hashtable getParentKids() {
        return this.pkids;
    }

    void annotate() {
        XMLDocument xMLDocument;
        try {
            xMLDocument = this.annotator.processBinXMLSchemaAnnotations();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
            xMLDocument = null;
        }
        if (this.debug) {
            try {
                xMLDocument.print(System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    BinXMLVocabId getSchemaId() {
        return this.sVocabID;
    }

    void setSchemaId(BinXMLVocabId binXMLVocabId) {
        this.sVocabID = binXMLVocabId;
    }

    int getSchemaVer() {
        return 0;
    }

    public BinXMLProperty getRootElemProperty() {
        return this.rootprop;
    }

    void setRootElemProperty(BinXMLProperty binXMLProperty) {
        this.rootprop = binXMLProperty;
    }

    short getKidNum(BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2) {
        return this.getKidNum(binXMLProperty, binXMLProperty2, this.pkids);
    }

    short getKidNum(int n, int n2, BinXMLProperty binXMLProperty) {
        Enumeration enumeration = this.pkidsNonSeq.keys();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            if (n3 != n) continue;
            Vector vector = (Vector)this.pkidsNonSeq.get(n3);
            for (int i = 0; i < vector.size(); ++i) {
                Integer n4 = (Integer)vector.get(i);
                if (n4 != n2) continue;
                return (short)(i + 1 + this.getMaxKidNum(binXMLProperty));
            }
        }
        return -1;
    }

    private short getMaxKidNum(BinXMLProperty binXMLProperty) {
        Enumeration enumeration = this.pkids.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (n.intValue() != binXMLProperty.getHashCode()) continue;
            Vector vector = (Vector)this.pkids.get(n);
            return (short)vector.size();
        }
        return 0;
    }

    private short getKidNum(BinXMLProperty binXMLProperty, BinXMLProperty binXMLProperty2, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (binXMLProperty.getHashCode() != n.intValue()) continue;
            Vector vector = (Vector)hashtable.get(n);
            for (int i = 0; i < vector.size(); ++i) {
                Integer n2 = (Integer)vector.get(i);
                if (binXMLProperty2.getHashCode() != n2.intValue()) continue;
                return (short)(i + 1);
            }
        }
        return -1;
    }

    BinXMLProperty getChildPropByQName(int n, QName qName, boolean bl) {
        Object object;
        int n2;
        Object object2 = null;
        for (n2 = 0; n2 < this.properties.size(); ++n2) {
            object = (BinXMLProperty)this.properties.get(n2);
            if (((BinXMLProperty)object).getPropId() != n) continue;
            object2 = object;
            break;
        }
        if (n2 == this.properties.size()) {
            return null;
        }
        object = this.pkids.keys();
        while (object.hasMoreElements()) {
            Integer n3 = (Integer)object.nextElement();
            int n4 = n3;
            if (n4 != ((BinXMLProperty)object2).getHashCode()) continue;
            Vector vector = (Vector)this.pkids.get(n3);
            for (int i = 0; i < vector.size(); ++i) {
                BinXMLProperty binXMLProperty = (BinXMLProperty)vector.get(i);
                if (binXMLProperty.getQName() != qName || binXMLProperty.isAttribute() != bl) continue;
                return binXMLProperty;
            }
        }
        return null;
    }

    BinXMLProperty getProperty(int n) {
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            if (binXMLProperty.getPropId() != n) continue;
            return binXMLProperty;
        }
        return null;
    }

    BinXMLProperty getProperty(QName qName, boolean bl) {
        for (int i = 0; i < this.properties.size(); ++i) {
            boolean bl2;
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            QName qName2 = binXMLProperty.getQName();
            if (qName2 != qName || (bl2 = binXMLProperty.isAttribute()) != bl) continue;
            return binXMLProperty;
        }
        return null;
    }

    BinXMLProperty getProperty(BinXMLProperty binXMLProperty, short s) {
        short s2 = binXMLProperty.getMaxKidNum();
        if (s <= s2) {
            return this.getProperty(binXMLProperty, s, this.pkids);
        }
        return this.getProperty(binXMLProperty, (short)(s - s2), this.pkidsNonSeq);
    }

    private BinXMLProperty getProperty(BinXMLProperty binXMLProperty, short s, Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            int n2 = n;
            if (n2 != binXMLProperty.getHashCode()) continue;
            Vector vector = (Vector)hashtable.get(n);
            int n3 = (Integer)vector.get(s - 1);
            BinXMLProperty binXMLProperty2 = this.getBinXMLPropFromHashCode(n3);
            return binXMLProperty2;
        }
        return null;
    }

    void putProperty(BinXMLProperty binXMLProperty, XMLDocument xMLDocument, int n) {
        if (this.properties.contains(binXMLProperty)) {
            return;
        }
        this.properties.add(binXMLProperty);
        int n2 = binXMLProperty.getParentHashCode();
        if (n2 != -1 && n == 1) {
            int n3 = binXMLProperty.getHashCode();
            this.putProperty(n2, n3, xMLDocument);
        } else if (n == 2) {
            int n4 = binXMLProperty.getHashCode();
            this.putProperty(n2, n4);
        }
    }

    private void putProperty(int n, int n2) {
        if (this.pkidsNonSeq == null) {
            this.pkidsNonSeq = new Hashtable(20, 0.5f);
        }
        Object object = this.pkidsNonSeq.keys();
        while (object.hasMoreElements()) {
            Integer n3 = (Integer)object.nextElement();
            if (n3 != n) continue;
            Vector vector = (Vector)this.pkidsNonSeq.get(n3);
            Integer n4 = new Integer(n2);
            vector.add(n4);
            return;
        }
        object = new Vector(5, 1);
        ((Vector)object).add(new Integer(n2));
        this.pkidsNonSeq.put(new Integer(n), object);
    }

    void putProperty(int n, int n2, XMLDocument xMLDocument) {
        Integer n3;
        Object object = this.pkids.keys();
        while (object.hasMoreElements()) {
            n3 = (Integer)object.nextElement();
            if (n3 != n) continue;
            Vector vector = (Vector)this.pkids.get(n3);
            Integer n4 = new Integer(n2);
            XMLElement xMLElement = (XMLElement)this.pkidlist.get(n3);
            if (xMLElement == null) {
                vector.add(n4);
                return;
            }
            BinXMLProperty binXMLProperty = this.getBinXMLPropFromHashCode(n2);
            boolean bl = this.insertKidsNotationNode(binXMLProperty, xMLElement, xMLDocument);
            if (bl) {
                vector.add(n4);
            }
            return;
        }
        object = new Vector(20, 5);
        n3 = new Integer(n2);
        Integer n5 = new Integer(n);
        this.pkids.put(n5, object);
        XSDNode xSDNode = this.getXSDNodeFromHashCode(n);
        XMLElement xMLElement = xSDNode.getDomNode();
        XMLElement xMLElement2 = this.putNotationRoot(xMLDocument, xSDNode, n5);
        if (xMLElement2 == null) {
            ((Vector)object).add(n3);
        } else {
            BinXMLProperty binXMLProperty = this.getBinXMLPropFromHashCode(n2);
            boolean bl = this.insertKidsNotationNode(binXMLProperty, xMLElement2, xMLDocument);
            if (bl) {
                ((Vector)object).add(n3);
            }
        }
    }

    BinXMLProperty locateDefinedProperty(int n, QName qName, int n2) {
        if (n == 0 || n2 == 1 || n2 == 2 || n2 == 4) {
            for (int i = 0; i < this.properties.size(); ++i) {
                BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
                if (binXMLProperty.getQName() != qName || binXMLProperty.getXSDNode().getNodeType() != n2) continue;
                return binXMLProperty;
            }
        }
        return null;
    }

    private BinXMLProperty getBinXMLPropFromHashCode(int n) {
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            if (binXMLProperty.getHashCode() != n) continue;
            return binXMLProperty;
        }
        return null;
    }

    private XSDNode getXSDNodeFromHashCode(int n) {
        BinXMLProperty binXMLProperty = this.getBinXMLPropFromHashCode(n);
        return binXMLProperty.getXSDNode();
    }

    private XMLElement getDOMNodeFromHashCode(int n) {
        XSDNode xSDNode = this.getXSDNodeFromHashCode(n);
        return xSDNode.getDomNode();
    }

    private QName getQNameFromHashCode(int n) {
        BinXMLProperty binXMLProperty = this.getBinXMLPropFromHashCode(n);
        return binXMLProperty.getQName();
    }

    BinXMLProperty getBinXMLPropertyFromXSDNode(XSDNode xSDNode) {
        for (int i = 0; i < this.properties.size(); ++i) {
            BinXMLProperty binXMLProperty = (BinXMLProperty)this.properties.get(i);
            if (binXMLProperty.getXSDNode() != xSDNode) continue;
            return binXMLProperty;
        }
        if (xSDNode instanceof XSDElement) {
            return this.locateDefinedProperty(((XSDElement)xSDNode).getRefState(), xSDNode.getQName(), xSDNode.getNodeType());
        }
        if (xSDNode instanceof XSDSimpleType) {
            return this.locateDefinedProperty(0, xSDNode.getQName(), xSDNode.getNodeType());
        }
        if (xSDNode instanceof XSDComplexType) {
            return this.locateDefinedProperty(0, xSDNode.getQName(), xSDNode.getNodeType());
        }
        return null;
    }

    Integer getHashCodeFromXSDNode(XSDNode xSDNode) {
        BinXMLProperty binXMLProperty = this.getBinXMLPropertyFromXSDNode(xSDNode);
        if (binXMLProperty != null) {
            return new Integer(binXMLProperty.getHashCode());
        }
        return null;
    }

    XMLElement putNotationRoot(XMLDocument xMLDocument, XSDNode xSDNode, Integer n) {
        BinXMLProperty binXMLProperty = this.getBinXMLPropertyFromXSDNode(xSDNode);
        if (this.isWithKidList(xSDNode)) {
            return null;
        }
        xMLDocument = BinXMLUtil.switchRoot(xSDNode, xMLDocument);
        XMLElement[] xMLElementArray = this.createKidListNotationRoot(xMLDocument);
        if (xSDNode instanceof XSDElement) {
            this.insertKidListNotationRoot((XSDElement)xSDNode, xMLElementArray[1], xMLDocument);
        } else if (xSDNode instanceof XSDComplexType) {
            this.insertKidListNotationRoot((XSDComplexType)xSDNode, xMLElementArray[1], xMLDocument);
        }
        this.pkidlist.put(n, xMLElementArray[0]);
        return xMLElementArray[0];
    }

    private boolean isWithKidList(XSDNode xSDNode) {
        XSDAnnotation xSDAnnotation = xSDNode instanceof XSDComplexType ? xSDNode.getAnnotation() : ((XSDElement)xSDNode).getType().getAnnotation();
        if (xSDAnnotation == null) {
            return false;
        }
        Vector vector = xSDAnnotation.getApplicationInformation();
        if (vector == null || vector.size() == 0) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            XMLElement xMLElement = (XMLElement)vector.get(i);
            NodeList nodeList = xMLElement.getElementsByTagNameNS("http://xmlns.oracle.com/2004/CSX", "kidList");
            if (nodeList == null || nodeList.getLength() < 1) continue;
            return true;
        }
        return false;
    }

    private void insertKidListNotationRoot(XSDComplexType xSDComplexType, XMLElement xMLElement, XMLDocument xMLDocument) {
        XMLElement xMLElement2 = xSDComplexType.getDomNode();
        XMLNode xMLNode = (XMLNode)xMLElement2.getFirstChild();
        if (xMLNode == null) {
            xMLElement2.insertBefore(xMLElement, xMLNode);
        } else {
            QxName qxName = xMLNode.getQName();
            if (qxName.getLocalPart().equals("annotation") && qxName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                return;
            }
            xMLElement2.insertBefore(xMLElement, xMLNode);
        }
    }

    private void insertKidListNotationRoot(XSDElement xSDElement, XMLElement xMLElement, XMLDocument xMLDocument) {
        XSDNode xSDNode = xSDElement.getType();
        if (!(xSDNode instanceof XSDComplexType)) {
            return;
        }
        int n = xSDElement.getContent();
        XSDNode[] xSDNodeArray = xSDElement.getChildElements();
        XMLElement xMLElement2 = xSDElement.getDomNode();
        NodeList nodeList = xMLElement2.getChildrenByTagName("complexType", "http://www.w3.org/2001/XMLSchema");
        int n2 = nodeList.getLength();
        XMLElement xMLElement3 = null;
        if (n2 == 1) {
            xMLElement3 = (XMLElement)nodeList.item(0);
            XMLNode xMLNode = (XMLNode)xMLElement3.getFirstChild();
            xMLElement3.insertBefore(xMLElement, xMLNode);
        } else if (n2 == 0) {
            // empty if block
        }
    }

    private XMLElement createComplexTypeNode(XMLDocument xMLDocument) {
        String string = "complexType";
        if (this.rootprefix != null && this.rootprefix.length() > 0) {
            string = this.rootprefix + ":" + string;
        }
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", string);
        return xMLElement;
    }

    XMLElement[] createKidListNotationRoot(XMLDocument xMLDocument) {
        XMLElement[] xMLElementArray = new XMLElement[2];
        String string = "annotation";
        String string2 = "appinfo";
        if (this.rootprefix != null && this.rootprefix.length() > 0) {
            string = this.rootprefix + ":" + string;
            string2 = this.rootprefix + ":" + string2;
        }
        XMLElement xMLElement = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", string);
        XMLElement xMLElement2 = (XMLElement)xMLDocument.createElementNS("http://www.w3.org/2001/XMLSchema", string2);
        XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://xmlns.oracle.com/2004/CSX", "csx:kidList");
        xMLElement3.setAttribute("sequential", "true");
        xMLElement2.appendChild(xMLElement3);
        xMLElement.appendChild(xMLElement2);
        xMLElementArray[0] = xMLElement3;
        xMLElementArray[1] = xMLElement;
        return xMLElementArray;
    }

    boolean insertKidsNotationNode(BinXMLProperty binXMLProperty, XMLElement xMLElement, XMLDocument xMLDocument) {
        if (xMLElement == null) {
            return true;
        }
        NodeList nodeList = xMLElement.getChildNodes();
        int n = nodeList == null ? 0 : nodeList.getLength();
        int n2 = binXMLProperty.getPropId();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                XMLElement xMLElement2 = (XMLElement)nodeList.item(i);
                String string = xMLElement2.getAttribute("propertyID");
                if (Integer.parseInt(string) != n2) continue;
                return false;
            }
        }
        XMLElement xMLElement3 = (XMLElement)xMLDocument.createElementNS("http://xmlns.oracle.com/2004/CSX", "csx:kid");
        xMLElement3.setAttribute("propertyID", new Integer(n2).toString());
        xMLElement3.setAttribute("kidNum", new Integer(n + 1).toString());
        xMLElement3 = (XMLElement)xMLElement.getDocument().importNode((Node)xMLElement3, true);
        xMLElement.appendChild(xMLElement3);
        return true;
    }

    void setRootPrefix(String string) {
        this.rootprefix = string;
    }

    public void showPropertyParentMappings() {
        Enumeration enumeration = this.pkids.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            Vector vector = (Vector)this.pkids.get(n);
            QName qName = this.getQNameFromHashCode(n);
            System.out.println(n + " " + qName.getLocalPart() + " --->");
            for (int i = 0; i < vector.size(); ++i) {
                Integer n2 = (Integer)vector.get(i);
                System.out.print(n2 + " ");
                QName qName2 = this.getQNameFromHashCode(n2);
                System.out.println(qName2.getLocalPart());
            }
        }
    }

    public void showPropertySingleMappings() {
        for (int i = 0; i < this.properties.size(); ++i) {
            int n = ((BinXMLProperty)this.properties.get(i)).getPropId();
            int n2 = ((BinXMLProperty)this.properties.get(i)).getTypeId();
            QName qName = ((BinXMLProperty)this.properties.get(i)).getQName();
            String string = qName.getLocalPart();
            int n3 = ((BinXMLProperty)this.properties.get(i)).getHashCode();
            int n4 = ((BinXMLProperty)this.properties.get(i)).getParentHashCode();
            System.out.println("prop id: " + n + " & type id: " + n2);
            System.out.println("local name: " + string);
            System.out.println("hash code: " + n3);
            System.out.println("parent hash code: " + n4);
            System.out.println();
        }
    }
}

