/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tns;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TNSParser {
    private static final String REGEX_STEP1 = "ADDRESS_LIST\\s*=[^#]*?CONNECT_DATA\\s*=.*?(\\)|\\s)+\\)";
    private static final String REGEX_STEP2 = "HOST\\s*=\\s*([^\\)]+)[^#]*PORT\\s*=\\s*([^\\)]+)[^#]*(SID|SERVICE_NAME)\\s*=\\s*(\\w+)";

    public static List<TNSEntry> parse(String source) {
        ArrayList<TNSEntry> tnsList = new ArrayList<TNSEntry>();
        String content = TNSParser.readFile(source);
        try {
            Pattern regex = Pattern.compile(REGEX_STEP1, 128);
            Pattern regexPattern = Pattern.compile(REGEX_STEP2, 128);
            Matcher regexMatcher = regex.matcher(content);
            while (regexMatcher.find()) {
                String tmpConent = regexMatcher.group(0);
                Matcher matcher = regexPattern.matcher(tmpConent);
                while (matcher.find()) {
                    TNSEntry entry = new TNSEntry();
                    entry.setHost(matcher.group(1));
                    entry.setPort(Integer.parseInt(matcher.group(2)));
                    if (matcher.group(3).equals("SID")) {
                        entry.setSid(matcher.group(4));
                    } else if (matcher.group(3).equals("SERVICE_NAME")) {
                        entry.setServiceName(matcher.group(4));
                    }
                    tnsList.add(entry);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return tnsList;
    }

    public static String readFile(String source) {
        StringBuilder content = new StringBuilder();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(new File(source)));
                String tmpContent = null;
                while ((tmpContent = br.readLine()) != null) {
                    content.append(tmpContent);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return content.toString();
    }

    public static class TNSEntry {
        private String host;
        private int port;
        private String sid;
        private String serviceName;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getSid() {
            return this.sid;
        }

        public void setSid(String sid) {
            this.sid = sid;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }
    }
}

